package com.elitesland.cbpl.infinity.client.router.vo;

import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Data
public class RouterAuthVO {

    /**
     * 平台账号ID
     */
    private Long id;

    /**
     * 组织编码
     */
    private String buCode;

    /**
     * 平台编码
     */
    private String platFormCode;

    /**
     * 平台账号
     */
    private String username;

    /**
     * 平台密码
     */
    private String password;

    /**
     * 登录用户名
     */
    private String loginName;

    /**
     * app_key
     */
    private String appKey;

    /**
     * target_app_key
     */
    private String targetAppKey;

    /**
     * app_secret
     */
    private String appSecret;

    /**
     * 是否加密
     */
    private Boolean isEncrypt;

    /**
     * 加密方式
     */
    private String encryptMethod;

    /**
     * 备注
     */
    private String remark;

    /**
     * sid
     */
    private String sid;

    /**
     * 接口相关规则定义
     */
    private InfinityRouterRespVO router;

    public String getUrl() {
        return router.getUrl();
    }

    public RequestMethod getRequestMethod() {
        return router.getRequestMethod();
    }

    public boolean requiredAuth() {
        return router.getIsAuth().equals("1");
    }

    public String getUrlParseMethod() {
        return router.getUrlParseMethod();
    }

    public String getRouterCode() {
        return router.getRouterCode();
    }

    /**
     * 认证方式
     */
    public String getAuthMethod() {
        return router.getAuthMethod().name();
    }
}
