/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.router.builder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitesland.cbpl.infinity.client.router.service.RouterAuthService;
import com.elitesland.cbpl.infinity.client.router.util.InfinityUtil;
import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitesland.cbpl.infinity.server.router.enums.AuthMethod;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="GENERAL")
public class GeneralParamBuilder
implements RouterParamBuilder {
    private static final Logger log = LoggerFactory.getLogger(GeneralParamBuilder.class);
    private final RouterAuthService routerAuthService;

    @Override
    public <T, K extends ResponseVO> HttpParam<T, K> routerParamBuilder(InfinityRouterParamVO routerParam, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        RouterAuthVO routerAuth = this.routerAuthService.queryRouterAuth(routerParam);
        HttpParam params = new HttpParam();
        params.setUrl(routerAuth.getUrl());
        params.setRequestMethod(routerAuth.getRequestMethod());
        if (routerAuth.requiredAuth()) {
            if (routerAuth.getAuthMethod().equals(AuthMethod.BASIC.name())) {
                params.setHeaders(InfinityUtil.setBasicAuth(routerAuth));
            } else {
                log.trace("[INFINITY] NoAuth, RouterAuthVO({}).", (Object)routerAuth);
            }
        }
        params.setBody(requestBody);
        if (ObjectUtil.isNotEmpty(resultType)) {
            params.setResultType(resultType);
        }
        if (ObjectUtil.isNotEmpty(responseType)) {
            params.setResponseType(responseType);
        }
        return params;
    }

    public GeneralParamBuilder(RouterAuthService routerAuthService) {
        this.routerAuthService = routerAuthService;
    }
}

