package com.elitesland.cbpl.infinity.client.account.annotation.aop;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Aspect
@Slf4j
@Component
@RequiredArgsConstructor
public class InfinityAop {

    @Pointcut("@annotation(com.elitesland.cbpl.infinity.client.account.annotation.InfinityApi)")
    public void infinityApi() {
    }

    @Around("infinityApi()")
    public Object around(ProceedingJoinPoint point) throws Throwable {

        Object result = point.proceed();

        return result;
    }
}
