package com.elitesland.cbpl.infinity.client.account.interceptor;

import cn.hutool.core.date.StopWatch;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.TenantClient;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitescloud.cloudt.tenant.provider.TenantProvider;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.protocol.HTTP;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

/**
 * @Author ryan.xu
 * @since 2021/3/24
 */
@Slf4j
@Data
@NoArgsConstructor
public class AuthInterceptor implements HandlerInterceptor {

    @Resource
    private TenantProvider tenantProvider;
    private InfinityAccountRespVO account;

    public AuthInterceptor(InfinityAccountRespVO account) {
        this.account = account;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        log.info("current tenant: {}", TenantSession.getCurrentTenant());
        StopWatch watch = new StopWatch("Authorization Watching");
        watch.start();
        CloudtOptional<SysTenantDTO> tenantDTO = tenantProvider.getById(account.getBelongTenant());
        SysTenantDTO tenant = tenantDTO.get();
        log.info("query tenant: {}", tenant);
        TenantSession.setCurrentTenant(tenant);
        log.info("switch tenant: {}", TenantSession.getCurrentTenant());
        response.addHeader(HTTP.CONTENT_TYPE, "application/json;charset=UTF-8");
        try {
            // get header token
            final String requestMethod = request.getMethod();
            final String token = request.getHeader("Authorization");
            log.info("checkApiToken: check token,request method={},header token={}", requestMethod, token);
            // token
            if (StringUtils.isBlank(token)) {
                response.setStatus(401);
                log.error("请求参数非法，请核实!");
                return false;
            }
            if (!checkSignature(token)) {
                response.setStatus(203);
                log.error("checkApiToken: authorization invalid,head Authorization={}", token);
                return false;
            }
            return true;
        } catch (Exception e) {
            log.error("checkApiToken: catch e.", e);
            response.setStatus(500);
            return false;
        } finally {
            watch.stop();
            log.debug("checkApiToken: use time={}s.", watch.prettyPrint(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {

    }

    public boolean checkSignature(String authorization) {
        String auth = "TIMS_OA:XpSQSUzRCUzRA==";
        byte[] encodedAuth = Base64.encodeBase64((auth.getBytes(StandardCharsets.US_ASCII)));
        String authHeader = "Basic " + new String(encodedAuth);
        return authHeader.equals(authorization);
    }

//    private R applyTenant(Callable<R> runnable, SysTenantDTO tenant) throws Exception {
//        // 如果之前不使用租户，则先取消
//        var hasNot = TenantSession.getNoTenant();
//        if (hasNot) {
//            TenantSession.clearNoTenant();
//        }
//
//        // 如果之前使用默认的，则先取消使用默认
//        var hasUsedDefault = TenantSession.getUseDefault();
//        if (hasUsedDefault) {
//            TenantSession.clearUseDefault();
//        }
//
//        // 判断当前事务的租户与新的租户是否一致，如果一致，则直接执行
//        if (!hasNot && !hasUsedDefault) {
//            var currentTenant = TenantClient.getSessionTenant();
//            if (currentTenant != null && currentTenant.getId().longValue() == tenant.getId()) {
//                return runnable.call();
//            }
//        }
//
//        // 如果之前设置了session的租户，则先更换
//        var hasUsedTenant = TenantSession.getCurrentTenant();
//        TenantSession.setCurrentTenant(tenant);
//
//        E customParam = null;
//        try {
//            customParam = beforeApply(runnable, tenant);
//            R result = runnable.call();
//
//            executeCompletion(result, customParam, false, null);
//            return result;
//        } catch (Exception e) {
//            log.error("执行事务异常：", e);
//            executeCompletion(null, customParam, false, e);
//            throw e;
//        } finally {
//            // 恢复原session 租户
//            if (hasUsedTenant == null) {
//                TenantSession.clearCurrentTenant();
//            } else {
//                TenantSession.setCurrentTenant(hasUsedTenant);
//            }
//
//            // 恢复原是否使用默认
//            if (hasUsedDefault) {
//                TenantSession.setUseDefault();
//            }
//
//            // 恢复不使用
//            if (hasNot) {
//                TenantSession.setNoTenant();
//            }
//        }
//    }
}
