package com.elitesland.cbpl.infinity.client.router.service;

import com.elitesland.cbpl.infinity.client.router.convert.RouterConvert;
import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import com.elitesland.cbpl.infinity.server.platform.service.InfinityPlatformService;
import com.elitesland.cbpl.infinity.server.platform.vo.resp.InfinityPlatformRespVO;
import com.elitesland.cbpl.infinity.server.router.service.InfinityRouterService;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RouterAuthServiceImpl implements RouterAuthService {

    private final InfinityRouterService routerService;
    private final InfinityPlatformService platformService;

    @Override
    public RouterAuthVO queryRouterAuth(InfinityRouterParamVO routerParam) {
        // 平台账号
        InfinityPlatformRespVO auth = platformService.queryOneAuth(routerParam);
        RouterAuthVO result = RouterConvert.INSTANCE.authToDTO(auth);
        // 接口地址
        routerParam.setAuthId(auth.getId());
        InfinityRouterRespVO router = routerService.queryOneApi(routerParam);
        result.setRouter(router);
        return result;
    }
}
