/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.account.interceptor;

import cn.hutool.core.date.StopWatch;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitescloud.cloudt.tenant.provider.TenantProvider;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    @Resource
    private TenantProvider tenantProvider;
    private InfinityAccountRespVO account;

    public AuthInterceptor(InfinityAccountRespVO account) {
        this.account = account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        log.info("current tenant: {}", (Object)TenantSession.getCurrentTenant());
        StopWatch watch = new StopWatch("Authorization Watching");
        watch.start();
        CloudtOptional tenantDTO = this.tenantProvider.getById(this.account.getBelongTenant());
        SysTenantDTO tenant = (SysTenantDTO)tenantDTO.get();
        log.info("query tenant: {}", (Object)tenant);
        TenantSession.setCurrentTenant((SysTenantDTO)tenant);
        log.info("switch tenant: {}", (Object)TenantSession.getCurrentTenant());
        response.addHeader("Content-Type", "application/json;charset=UTF-8");
        try {
            String requestMethod = request.getMethod();
            String token = request.getHeader("Authorization");
            log.info("checkApiToken: check token,request method={},header token={}", (Object)requestMethod, (Object)token);
            if (StringUtils.isBlank((CharSequence)token)) {
                response.setStatus(401);
                log.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
                boolean bl = false;
                return bl;
            }
            if (!this.checkSignature(token)) {
                response.setStatus(203);
                log.error("checkApiToken: authorization invalid,head Authorization={}", (Object)token);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("checkApiToken: catch e.", (Throwable)e);
            response.setStatus(500);
            boolean bl = false;
            return bl;
        }
        finally {
            watch.stop();
            log.debug("checkApiToken: use time={}s.", (Object)watch.prettyPrint(TimeUnit.MILLISECONDS));
        }
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }

    public boolean checkSignature(String authorization) {
        String auth = "TIMS_OA:XpSQSUzRCUzRA==";
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuth);
        return authHeader.equals(authorization);
    }

    public TenantProvider getTenantProvider() {
        return this.tenantProvider;
    }

    public InfinityAccountRespVO getAccount() {
        return this.account;
    }

    public void setTenantProvider(TenantProvider tenantProvider) {
        this.tenantProvider = tenantProvider;
    }

    public void setAccount(InfinityAccountRespVO account) {
        this.account = account;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInterceptor)) {
            return false;
        }
        AuthInterceptor other = (AuthInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantProvider this$tenantProvider = this.getTenantProvider();
        TenantProvider other$tenantProvider = other.getTenantProvider();
        if (this$tenantProvider == null ? other$tenantProvider != null : !this$tenantProvider.equals(other$tenantProvider)) {
            return false;
        }
        InfinityAccountRespVO this$account = this.getAccount();
        InfinityAccountRespVO other$account = other.getAccount();
        return !(this$account == null ? other$account != null : !this$account.equals(other$account));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantProvider $tenantProvider = this.getTenantProvider();
        result = result * 59 + ($tenantProvider == null ? 43 : $tenantProvider.hashCode());
        InfinityAccountRespVO $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        return result;
    }

    public String toString() {
        return "AuthInterceptor(tenantProvider=" + this.getTenantProvider() + ", account=" + this.getAccount() + ")";
    }

    public AuthInterceptor() {
    }
}

