/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.router.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpUtil;
import com.elitesland.cbpl.infinity.client.router.builder.RouterParamBuilder;
import com.elitesland.cbpl.infinity.client.router.service.RouterClientService;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import com.elitesland.cbpl.infinity.web.http.service.RestClient;
import com.elitesland.cbpl.infinity.web.util.BeanConvertUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class RouterClientServiceImpl
implements RouterClientService {
    private static final Logger log = LoggerFactory.getLogger(RouterClientServiceImpl.class);
    private final RouterParamBuilder routerParamBuilder;
    private final RestClient restClient;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public <T, K extends ResponseVO> List<T> query(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<T> resultType, Class<K> responseType) {
        HttpParam<T, K> routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, resultType, responseType);
        try {
            ResponseVO response = this.restClient.exchangeToBean(routerParam);
            if (ResponseVO.success((ResponseVO)response, (String)"S")) {
                List entities = response.getData();
                log.trace("[HTTP-REQ] RESULT LIST: {}", (Object)entities);
                return BeanConvertUtil.toEntities((List)entities, (Class)routerParam.getResultType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.error("[HTTP-REQ] QUERY FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanConvertUtil.hashMapToString((Map)routerParam.getBody()));
        return Collections.emptyList();
    }

    @Override
    public <K extends ResponseVO> K send(InfinityRouterParamVO param, Map<String, Object> requestBody, Class<K> responseType) {
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, responseType);
        try {
            return (K)this.restClient.exchangeToBean(routerParam);
        }
        catch (Exception e) {
            String message = e.getMessage();
            e.printStackTrace();
            log.error("[HTTP-REQ] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanConvertUtil.hashMapToString((Map)routerParam.getBody()));
            return (K)((ResponseVO)BeanUtil.toBean((Object)ResponseVO.error((String)message), responseType));
        }
    }

    @Override
    public String exchange(InfinityRouterParamVO param, Map<String, Object> requestBody) {
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, null);
        try {
            return this.restClient.exchange(routerParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[HTTP-REQ] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanConvertUtil.hashMapToString((Map)routerParam.getBody()));
            return "";
        }
    }

    @Override
    public Resource exchangeStream(InfinityRouterParamVO param, Map<String, Object> requestBody) {
        HttpParam routerParam = this.routerParamBuilder.routerParamBuilder(param, requestBody, null, null);
        try {
            String queryParams = HttpUtil.toParams((Map)routerParam.getBody(), (Charset)StandardCharsets.UTF_8);
            String requestUrl = routerParam.getUrl() + "?" + queryParams;
            HttpEntity entity = this.restClient.getMethodHttpEntity(routerParam.getHeaders());
            return (Resource)this.restTemplate.exchange(URI.create(requestUrl), HttpMethod.GET, entity, Resource.class).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[HTTP-REQ] PUT FAIL. URL({}), PARAMS:({})", (Object)routerParam.getUrl(), (Object)BeanConvertUtil.hashMapToString((Map)routerParam.getBody()));
            return null;
        }
    }

    public RouterClientServiceImpl(RouterParamBuilder routerParamBuilder, RestClient restClient) {
        this.routerParamBuilder = routerParamBuilder;
        this.restClient = restClient;
    }
}

