package com.elitesland.cbpl.infinity.client.account.config;

import com.elitesland.cbpl.infinity.client.account.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Configuration
public class InfinityMvcConfigurer implements WebMvcConfigurer {

    @Resource
    private InfinityAccountService accountService;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<InfinityAccountRespVO> accounts = accountService.queryAccounts("");
        for (var account : accounts) {
            List<String> interceptUri = List.of(account.getInterceptUri().split(","));
            registry.addInterceptor(new AuthInterceptor(account)).addPathPatterns(interceptUri);
        }
    }
}
