/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.account.interceptor;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.config.support.DefaultTenantProvider;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private InfinityAccountRespVO account;
    private SysTenantDTO hasUsedTenant;
    private boolean hasUsedDefault;
    private boolean hasNot;

    public AuthInterceptor(InfinityAccountRespVO account) {
        this.account = account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        block7: {
            String token;
            block6: {
                this.setCurrentTenant();
                response.addHeader("Content-Type", "application/json;charset=UTF-8");
                String requestMethod = request.getMethod();
                token = request.getHeader("Authorization");
                log.info("checkApiToken: check token,request method={},header token={}", (Object)requestMethod, (Object)token);
                if (!StringUtils.isBlank((CharSequence)token)) break block6;
                response.setStatus(401);
                log.error("\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6838\u5b9e!");
                boolean bl = false;
                return bl;
            }
            if (this.checkSignature(token, this.account.getUsername(), this.account.getPassword())) break block7;
            response.setStatus(203);
            log.error("checkApiToken: authorization invalid,head Authorization={}", (Object)token);
            boolean bl = false;
            return bl;
        }
        try {
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("checkApiToken: catch e.", (Throwable)e);
            response.setStatus(500);
            boolean bl = false;
            return bl;
        }
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
        this.resetCurrentTenant();
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }

    private boolean checkSignature(String authorization, String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuth);
        return authHeader.equals(authorization);
    }

    private void setCurrentTenant() {
        boolean hasNot = TenantSession.getNoTenant();
        if (hasNot) {
            TenantSession.clearNoTenant();
        }
        this.hasUsedDefault = TenantSession.getUseDefault();
        if (this.hasUsedDefault) {
            TenantSession.clearUseDefault();
        }
        DefaultTenantProvider tenantProvider = (DefaultTenantProvider)SpringUtil.getBean(DefaultTenantProvider.class);
        CloudtOptional tenantDTO = tenantProvider.getById(this.account.getBelongTenant());
        this.hasUsedTenant = (SysTenantDTO)tenantDTO.get();
        TenantSession.setCurrentTenant((SysTenantDTO)this.hasUsedTenant);
    }

    private void resetCurrentTenant() {
        if (this.hasUsedTenant == null) {
            TenantSession.clearCurrentTenant();
        } else {
            TenantSession.setCurrentTenant((SysTenantDTO)this.hasUsedTenant);
        }
        if (this.hasUsedDefault) {
            TenantSession.setUseDefault();
        }
        if (this.hasNot) {
            TenantSession.setNoTenant();
        }
    }

    public InfinityAccountRespVO getAccount() {
        return this.account;
    }

    public SysTenantDTO getHasUsedTenant() {
        return this.hasUsedTenant;
    }

    public boolean isHasUsedDefault() {
        return this.hasUsedDefault;
    }

    public boolean isHasNot() {
        return this.hasNot;
    }

    public void setAccount(InfinityAccountRespVO account) {
        this.account = account;
    }

    public void setHasUsedTenant(SysTenantDTO hasUsedTenant) {
        this.hasUsedTenant = hasUsedTenant;
    }

    public void setHasUsedDefault(boolean hasUsedDefault) {
        this.hasUsedDefault = hasUsedDefault;
    }

    public void setHasNot(boolean hasNot) {
        this.hasNot = hasNot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInterceptor)) {
            return false;
        }
        AuthInterceptor other = (AuthInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasUsedDefault() != other.isHasUsedDefault()) {
            return false;
        }
        if (this.isHasNot() != other.isHasNot()) {
            return false;
        }
        InfinityAccountRespVO this$account = this.getAccount();
        InfinityAccountRespVO other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        SysTenantDTO this$hasUsedTenant = this.getHasUsedTenant();
        SysTenantDTO other$hasUsedTenant = other.getHasUsedTenant();
        return !(this$hasUsedTenant == null ? other$hasUsedTenant != null : !this$hasUsedTenant.equals(other$hasUsedTenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasUsedDefault() ? 79 : 97);
        result = result * 59 + (this.isHasNot() ? 79 : 97);
        InfinityAccountRespVO $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        SysTenantDTO $hasUsedTenant = this.getHasUsedTenant();
        result = result * 59 + ($hasUsedTenant == null ? 43 : $hasUsedTenant.hashCode());
        return result;
    }

    public String toString() {
        return "AuthInterceptor(account=" + this.getAccount() + ", hasUsedTenant=" + this.getHasUsedTenant() + ", hasUsedDefault=" + this.isHasUsedDefault() + ", hasNot=" + this.isHasNot() + ")";
    }

    public AuthInterceptor() {
    }
}

