package com.elitesland.cbpl.infinity.client.account.config;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.infinity.client.account.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Configuration
public class InfinityMvcConfigurer implements WebMvcConfigurer {

    @Resource
    private InfinityAccountService accountService;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<InfinityAccountRespVO> accounts = accountService.queryAccounts("");
        Map<String, List<InfinityAccountRespVO>> interceptors = new HashMap<>();
        for (var account : accounts) {
            for (String interceptUri : account.getInterceptUriList()) {
                var acc = interceptors.get(interceptUri);
                if (CollUtil.isEmpty(acc)) {
                    acc = new ArrayList<>();
                }
                acc.add(account);
                interceptors.put(interceptUri, acc);
            }
        }
        interceptors.forEach((interceptUri, acc) -> registry.addInterceptor(new AuthInterceptor(acc)).addPathPatterns(interceptUri));
    }
}
