package com.elitesland.cbpl.infinity.client.account.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.account.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.client.track.filter.LoggerFilter;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Nonnull;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Configuration
public class InfinityMvcConfigurer implements WebMvcConfigurer {

    @Resource
    private InfinityAccountService accountService;

    private Map<String, List<InfinityAccountRespVO>> interceptors;

    @Override
    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        // 注册拦截器
        interceptorMap().forEach((interceptUri, acc) -> registry.addInterceptor(new AuthInterceptor(acc)).addPathPatterns(interceptUri));
    }

//    /**
//     * 注册过滤器
//     */
//    @Bean
//    public FilterRegistrationBean<LoggerFilter> filterRegistrationBean() {
//        var filter = new FilterRegistrationBean<LoggerFilter>();
//        filter.setFilter(new LoggerFilter());
//        interceptorMap().forEach((interceptUri, acc) -> filter.addUrlPatterns(removeStar(interceptUri)));
//        return filter;
//    }

    private Map<String, List<InfinityAccountRespVO>> interceptorMap() {
        if (ObjectUtil.isNotNull(interceptors)) {
            return interceptors;
        }
        List<InfinityAccountRespVO> accounts = accountService.queryAccounts("");
        Map<String, List<InfinityAccountRespVO>> interceptors = new HashMap<>();
        for (var account : accounts) {
            for (String interceptUri : account.getInterceptUriList()) {
                var acc = interceptors.get(interceptUri);
                if (CollUtil.isEmpty(acc)) {
                    acc = new ArrayList<>();
                }
                acc.add(account);
                interceptors.put(interceptUri, acc);
            }
        }
        this.interceptors = interceptors;
        return interceptors;
    }

    private String removeStar(String url) {
        return url.endsWith("**") ? url.substring(0, url.length() - 1) : url;
    }
}
