package com.elitesland.cbpl.infinity.client.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2023/06/14
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "cbpl.infinity.client")
public class InfinityClientConfig implements InitializingBean {

    @ApiModelProperty("日志记录开关：默认关闭")
    private boolean logEnabled;

    /**
     * 日志数据库（仅指定写入形式，系统需支持对应环境）；支持mysql、oracle、mongo、es；
     */
    @ApiModelProperty("日志数据库")
    private String logMode;

    /**
     * 日志索引生命周期策略名称（可选）
     */
    @ApiModelProperty("索引策略")
    private String policyName;

    /**
     * 日志滚动更新别名（索引策略存在时，该属性必填）
     */
    @ApiModelProperty("滚动更新别名")
    private String rolloverAlias;

    public static boolean INFINITY_LOG_ENABLED;
    public static String INFINITY_LOG_MODE;
    public static String INFINITY_POLICY_NAME;
    public static String INFINITY_ROLLOVER_ALIAS;

    @Override
    public void afterPropertiesSet() throws Exception {
        INFINITY_LOG_ENABLED = logEnabled;
        INFINITY_LOG_MODE = logMode;
        INFINITY_POLICY_NAME = policyName;
        INFINITY_ROLLOVER_ALIAS = rolloverAlias;
    }
}
