package com.elitesland.cbpl.infinity.client.router.util;

import com.elitesland.cbpl.infinity.client.router.vo.RouterAuthVO;
import org.apache.commons.codec.binary.Base64;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/04/20
 */
public class InfinityUtil {

    /**
     * Basic Auth
     *
     * @param routerAuth 接口相关参数
     * @return 加密后的头部信息
     */
    public static Map<String, String> setBasicAuth(RouterAuthVO routerAuth) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", encryptBasicAuth(routerAuth.getUsername(), routerAuth.getPassword()));
        return headers;
    }

    /**
     * Basic Auth 加密
     *
     * @param username 用户名
     * @param password 密码
     * @return 加密token
     */
    public static String encryptBasicAuth(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((auth.getBytes(StandardCharsets.US_ASCII)));
        return "Basic " + new String(encodedAuth);
    }

    /**
     * 接口鉴权
     *
     * @param authorization 头部token
     * @param username      用户名
     * @param password      密码
     * @return 鉴权结果
     */
    public static boolean checkSignature(String authorization, String username, String password) {
        return encryptBasicAuth(username, password).equals(authorization);
    }
}
