package com.elitesland.cbpl.infinity.client.track.filter;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackService;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackServiceImpl;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static org.springframework.util.MimeTypeUtils.APPLICATION_JSON_VALUE;

/**
 * @author eric.hao
 * @since 2023/06/15
 */
@Slf4j
@NoArgsConstructor
public class LoggerFilter extends OncePerRequestFilter {

    @Override
    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) {
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        RequestWrapper requestWrapper = new RequestWrapper(request);
        try {
            InfinityTrackService trackService = SpringUtil.getBean(InfinityTrackServiceImpl.class);
            filterChain.doFilter(request, responseWrapper);
            trackService.log(requestWrapper, responseWrapper, TenantSession.getCurrentTenant());
            response.setContentType(APPLICATION_JSON_VALUE);
            // 将buffer重置，重新写入流
            response.resetBuffer();
            response.setContentLength(responseWrapper.getResponseData().length);
            response.getOutputStream().write(responseWrapper.getResponseData());
        } catch (Exception e) {
            log.error("[INFINITY] 数据包装器执行出错：{}", ExceptionUtils.formatException(e));
        }
    }
}
