package com.elitesland.cbpl.infinity.client.track.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.service.ElasticTrackService;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

import static com.elitesland.cbpl.infinity.client.config.InfinityClientConfig.*;
import static com.elitesland.cbpl.tool.es.domain.TrackEvent.TRACK_INFINITY;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityTrackServiceImpl implements InfinityTrackService {

    @Resource
    private ElasticsearchRepository elasticRepository;
    @Resource
    private ElasticTrackService elasticTrackService;

    @Override
    public void log(RequestWrapper request, ResponseWrapper response, SysTenantDTO tenant) {
        if (!INFINITY_LOG_ENABLED) {
            log.info("[INFINITY] config closed.");
            return;
        }
        Map<String, Object> param = new HashMap<>();
        param.put("CURRENT_TENANT", ObjectUtil.isNull(tenant) ? "-1" : tenant.getId().toString());
        param.put("RESPONSE_STATUS", response.getStatus());
        param.put("RESPONSE_DATA", response.getResponseString());
        String indexName = ElasticsearchUtil.indexNameByDay(INFINITY_ROLLOVER_ALIAS);
        String policy = StrUtil.blankToDefault(INFINITY_POLICY_NAME, "");
        String alias = StrUtil.blankToDefault(INFINITY_ROLLOVER_ALIAS, "");
        if (elasticRepository.createIndex(indexName, policy, alias)) {
            elasticTrackService.trackLog(request, indexName, TRACK_INFINITY.name(), param);
        }
    }
}
