package com.elitesland.cbpl.infinity.client.unicom.util;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
@Slf4j
@Component
public class InfinityAdapter implements UnicomAdapter {

    private static final String ERR_TENANT_CONTEXT_CONFIG = "找不到实施方案，请联系管理员";

    @Override
    public Object filter(List<Object> providers) {
        var customerProvider = providers.stream().filter(this::matchCustomize).findAny();
        if (customerProvider.isPresent()) {
            log.debug("[CBPL-PHOENIX] context provider: {}", customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }

        var generalProvider = providers.stream().filter(this::matchGeneral).findAny()
                .orElseThrow(() -> {
                    throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
                });
        log.debug("[CBPL-PHOENIX] context provider: {}", generalProvider.getClass().getSimpleName());
        return generalProvider;
    }

    private boolean matchCustomize(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return "TIMS".equals(annotation.value());
    }

    private boolean matchGeneral(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return "GENERAL".equals(annotation.value());
    }
}
