/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.account.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.infinity.client.account.interceptor.AuthInterceptor;
import com.elitesland.cbpl.infinity.server.account.service.InfinityAccountService;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InfinityMvcConfigurer
implements WebMvcConfigurer {
    @Resource
    private InfinityAccountService accountService;
    private Map<String, List<InfinityAccountRespVO>> interceptors;

    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        this.interceptorMap().forEach((interceptUri, acc) -> registry.addInterceptor((HandlerInterceptor)new AuthInterceptor((List<InfinityAccountRespVO>)acc)).addPathPatterns(new String[]{interceptUri}));
    }

    private Map<String, List<InfinityAccountRespVO>> interceptorMap() {
        if (ObjectUtil.isNotNull(this.interceptors)) {
            return this.interceptors;
        }
        List accounts = this.accountService.queryAccounts("");
        HashMap<String, List<InfinityAccountRespVO>> interceptors = new HashMap<String, List<InfinityAccountRespVO>>();
        for (InfinityAccountRespVO account : accounts) {
            for (String interceptUri : account.getInterceptUriList()) {
                ArrayList<InfinityAccountRespVO> acc = (ArrayList<InfinityAccountRespVO>)interceptors.get(interceptUri);
                if (CollUtil.isEmpty((Collection)acc)) {
                    acc = new ArrayList<InfinityAccountRespVO>();
                }
                acc.add(account);
                interceptors.put(interceptUri, acc);
            }
        }
        this.interceptors = interceptors;
        return interceptors;
    }

    private String removeStar(String url) {
        return url.endsWith("**") ? url.substring(0, url.length() - 1) : url;
    }
}

