/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.track.filter;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.tenant.config.support.TenantSession;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackService;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackServiceImpl;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class LoggerFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LoggerFilter.class);

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) {
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        RequestWrapper requestWrapper = new RequestWrapper(request);
        try {
            InfinityTrackService trackService = (InfinityTrackService)SpringUtil.getBean(InfinityTrackServiceImpl.class);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            trackService.log(requestWrapper, responseWrapper, TenantSession.getCurrentTenant());
            response.setContentType("application/json");
            response.resetBuffer();
            response.setContentLength(responseWrapper.getResponseData().length);
            response.getOutputStream().write(responseWrapper.getResponseData());
        }
        catch (Exception e) {
            log.error("[INFINITY] \u6570\u636e\u5305\u88c5\u5668\u6267\u884c\u51fa\u9519\uff1a{}", (Object)ExceptionUtils.formatException((Throwable)e));
        }
    }
}

