/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.client.track.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.infinity.client.config.InfinityClientConfig;
import com.elitesland.cbpl.infinity.client.track.service.InfinityTrackService;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import com.elitesland.cbpl.tool.es.domain.TrackEvent;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.service.ElasticTrackService;
import com.elitesland.cbpl.tool.es.util.ElasticsearchUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger log = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    @Resource
    private ElasticsearchRepository elasticRepository;
    @Resource
    private ElasticTrackService elasticTrackService;

    @Override
    public void log(RequestWrapper request, ResponseWrapper response, SysTenantDTO tenant) {
        if (!InfinityClientConfig.INFINITY_LOG_ENABLED) {
            log.info("[INFINITY] config closed.");
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", ObjectUtil.isNull((Object)tenant) ? "-1" : tenant.getId().toString());
        param.put("RESPONSE_STATUS", response.getStatus());
        param.put("RESPONSE_DATA", response.getResponseString());
        String indexName = ElasticsearchUtil.indexNameByDay((String)InfinityClientConfig.INFINITY_ROLLOVER_ALIAS);
        String policy = StrUtil.blankToDefault((CharSequence)InfinityClientConfig.INFINITY_POLICY_NAME, (String)"");
        String alias = StrUtil.blankToDefault((CharSequence)InfinityClientConfig.INFINITY_ROLLOVER_ALIAS, (String)"");
        if (this.elasticRepository.createIndex(indexName, policy, alias)) {
            this.elasticTrackService.trackLog(request, indexName, TrackEvent.TRACK_INFINITY.name(), param);
        }
    }
}

