package com.elitesland.cbpl.infinity.web.config;

import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import static com.elitesland.cbpl.infinity.web.config.InfinityConfig.*;

/**
 * @author eric.hao
 * @since 2021/07/13
 */
@Data
@Configuration
public class RestConfig {

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT);
        httpRequestFactory.setConnectTimeout(CONNECT_TIMEOUT);
        httpRequestFactory.setReadTimeout(READ_TIMEOUT);
        return new RestTemplate(httpRequestFactory);
    }
}
