/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.http.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.elitesland.cbpl.infinity.web.common.vo.ResponseVO;
import com.elitesland.cbpl.infinity.web.http.param.HttpParam;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

@Component
public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    @Resource
    private RestTemplate restTemplate;

    public <T, K extends ResponseVO> String exchange(HttpParam<T, K> param) {
        if (param.getRequestMethod().equals((Object)RequestMethod.GET)) {
            return this.get(param.getUrl(), param.getBody(), param.getHeaders());
        }
        if (param.getRequestMethod().equals((Object)RequestMethod.POST)) {
            String responseStr = MediaType.MULTIPART_FORM_DATA.equals((Object)param.getMediaType()) ? this.postFormData(param.getUrl(), param.getBody(), param.getHeaders()) : (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)param.getMediaType()) ? this.postFormUrlencoded(param.getUrl(), param.getBody(), param.getHeaders()) : this.postJsonData(param.getUrl(), param.getBody(), param.getHeaders()));
            return responseStr;
        }
        throw new RuntimeException("[INFINITY] only support: GET and POST.");
    }

    public <T, K extends ResponseVO> K exchangeToBean(HttpParam<T, K> param) {
        if (ObjectUtil.isNull(param.getResponseType())) {
            throw new RuntimeException("[INFINITY] NULL OF RESPONSE_TYPE.");
        }
        return ResponseVO.result(this.exchange(param), param.getResponseType());
    }

    public String get(String url, Map<String, Object> reqObj) {
        return this.get(url, reqObj, null);
    }

    public String get(String url, Map<String, Object> reqObj, Map<String, String> addHeaders) {
        String queryParams = HttpUtil.toParams(reqObj, (Charset)StandardCharsets.UTF_8);
        String requestUrl = url + "?" + queryParams;
        HttpEntity<String> entity = this.getMethodHttpEntity(addHeaders);
        return (String)this.restTemplate.exchange(URI.create(requestUrl), HttpMethod.GET, entity, String.class).getBody();
    }

    public String postFormData(String requestUrl, Map<String, Object> reqObj) {
        return this.postFormData(requestUrl, reqObj, null);
    }

    public String postFormData(String requestUrl, Map<String, Object> reqObj, Map<String, String> addHeaders) {
        HttpEntity<MultiValueMap<String, Object>> entity = this.getFormRequestHttpEntity(reqObj, "multipart/form-data", addHeaders);
        return (String)this.restTemplate.postForObject(requestUrl, entity, String.class, new Object[0]);
    }

    public String postFormUrlencoded(String requestUrl, Map<String, Object> reqObj) {
        return this.postFormUrlencoded(requestUrl, reqObj, null);
    }

    public String postFormUrlencoded(String requestUrl, Map<String, Object> reqObj, Map<String, String> addHeaders) {
        HttpEntity<MultiValueMap<String, Object>> entity = this.getFormRequestHttpEntity(reqObj, "application/x-www-form-urlencoded", addHeaders);
        return (String)this.restTemplate.postForObject(requestUrl, entity, String.class, new Object[0]);
    }

    public String postJsonData(String requestUrl, Map<String, Object> reqObj) {
        return this.postJsonData(requestUrl, reqObj, null);
    }

    public String postJsonData(String requestUrl, Map<String, Object> reqObj, Map<String, String> addHeaders) {
        HttpEntity<?> entity = this.getJsonRequestHttpEntity(reqObj, addHeaders);
        return (String)this.restTemplate.exchange(requestUrl, HttpMethod.POST, entity, String.class, new Object[0]).getBody();
    }

    public MultiValueMap<String, Object> requestBeanToFormParams(Map<String, Object> reqObj) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (String key : reqObj.keySet()) {
            multiValueMap.add((Object)key, reqObj.get(key));
        }
        return multiValueMap;
    }

    public HttpEntity<String> getMethodHttpEntity(Map<String, String> addHeaders) {
        HttpHeaders headers = this.getHttpHeaders(MediaType.APPLICATION_JSON);
        this.addHeaders(headers, addHeaders);
        return new HttpEntity(null, (MultiValueMap)headers);
    }

    public HttpEntity<MultiValueMap<String, Object>> getFormRequestHttpEntity(Map<String, Object> reqObj, String contentType, Map<String, String> addHeaders) {
        HttpHeaders headers = null;
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            headers = this.getHttpHeaders(MediaType.APPLICATION_FORM_URLENCODED);
        } else if ("multipart/form-data".equals(contentType)) {
            headers = this.getHttpHeaders(MediaType.MULTIPART_FORM_DATA);
        }
        this.addHeaders(headers, addHeaders);
        MultiValueMap<String, Object> multiValueMap = this.requestBeanToFormParams(reqObj);
        return new HttpEntity(multiValueMap, (MultiValueMap)headers);
    }

    public HttpEntity<?> getJsonRequestHttpEntity(Map<String, Object> obj, Map<String, String> addHeaders) {
        HttpHeaders headers = this.getHttpHeaders(MediaType.APPLICATION_JSON);
        this.addHeaders(headers, addHeaders);
        return new HttpEntity(obj, (MultiValueMap)headers);
    }

    public HttpHeaders getHttpHeaders(MediaType mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        return headers;
    }

    public void addHeaders(HttpHeaders headers, Map<String, String> addHeaders) {
        if (ObjectUtil.isEmpty(addHeaders)) {
            return;
        }
        for (String key : addHeaders.keySet()) {
            if ("Bearer-Auth".equals(key)) {
                headers.setBearerAuth(addHeaders.get(key));
                continue;
            }
            headers.set(key, addHeaders.get(key));
        }
    }
}

