/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.infinity.web.util;

import com.elitesland.cbpl.infinity.web.util.StringFormatUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class BeanConvertUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T toEntity(String response, Class<T> cls) throws IOException {
        Objects.requireNonNull(response);
        Objects.requireNonNull(cls);
        return (T)OBJECT_MAPPER.readValue(response, cls);
    }

    public static <T> List<T> toEntities(List<Map<String, Object>> response, Class<T> cls) throws IOException {
        return response.stream().map(row -> {
            try {
                return BeanConvertUtil.toEntity(BeanConvertUtil.toJsonStr(row), cls);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> String toJsonStr(T payload) {
        Objects.requireNonNull(payload);
        try {
            return OBJECT_MAPPER.writeValueAsString(payload);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "[]";
        }
    }

    public static String hashMapToString(Map<String, Object> param) {
        return param.entrySet().stream().map(entry -> StringFormatUtil.bracket(entry.getKey()) + " : " + BeanConvertUtil.hashValueToString(entry.getValue())).collect(Collectors.joining(", ", "{", "}"));
    }

    private static String hashValueToString(Object value) {
        if (value instanceof Object[]) {
            List<String> result = Arrays.asList(BeanConvertUtil.resolveStr(value));
            return result.toString();
        }
        if (value instanceof List) {
            return ((ArrayList)value).stream().map(BeanConvertUtil::hashValueToString).collect(Collectors.joining(", ", "[", "]"));
        }
        if (value instanceof Map) {
            return BeanConvertUtil.hashMapToString((Map)value);
        }
        return StringFormatUtil.bracket(value);
    }

    public static String[] resolveStr(Object paramStr) {
        String[] stringArray;
        if (BeanConvertUtil.isEmpty(paramStr)) {
            return new String[0];
        }
        if (paramStr instanceof String) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)paramStr;
        } else {
            stringArray = BeanConvertUtil.resolveArr((Object[])paramStr);
        }
        return stringArray;
    }

    private static String[] resolveArr(Object[] paramArr) {
        return (String[])Arrays.copyOf(paramArr, paramArr.length, String[].class);
    }

    public static boolean isEmpty(Object str) {
        if (str == null) {
            return true;
        }
        if (str.getClass().isArray()) {
            if (Array.getLength(str) == 0) {
                return true;
            }
            if (Array.getLength(str) == 1) {
                Object obj = Array.get(str, 0);
                return obj instanceof String && ((String)obj).length() == 0;
            }
        } else {
            return str instanceof String && ((String)str).length() == 0;
        }
        return false;
    }

    public static HashMap<String, Object> entityToMap(Object obj) throws Exception {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
            Method getMethod = pd.getReadMethod();
            Object o = getMethod.invoke(obj, new Object[0]);
            if (null == o) continue;
            map.put(field.getName(), o);
        }
        return map;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

