package com.elitesland.cbpl.infinity.web.common.vo;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2021/07/19
 */
public abstract class ResponseVO implements Serializable {

    private static final long serialVersionUID = -7204196611638488980L;

    public abstract void setCode(String code);

    public static final String success_code = "200";
    public static final String fail_code = "500";

    /**
     * 接口返回码
     */
    public abstract String getCode();

    public abstract void setMessage(String message);

    /**
     * 返回码说明
     */
    public abstract String getMessage();

    public abstract void setData(List<Map<String, Object>> Data);

    /**
     * 数据集
     */
    public abstract List<Map<String, Object>> getData();

    public abstract void setBizCode(String bizCode);

    /**
     * 业务单据主键
     */
    public abstract String getBizCode();

    public static <T extends ResponseVO> T of(String code, String msg) {
        ResponseCommVO resp = new ResponseCommVO();
        resp.setCode(code);
        resp.setMessage(msg);
        return (T) resp;
    }

    public static <T extends ResponseVO> T ok() {
        return ResponseVO.of("S", "调用成功");
    }

    public static <T extends ResponseVO> T error(String message) {
        return ResponseVO.of("E", message);
    }

    public static <T extends ResponseVO> T error() {
        return ResponseVO.of("E", "内部错误，请联系管理员。");
    }

    public static <T extends ResponseVO> T empty() {
        return ResponseVO.of("E", "无数据");
    }

    @SneakyThrows
    public static <T extends ResponseVO> T result(String response, Class<T> clazz) {
        return StringUtils.isBlank(response) ? ResponseVO.empty() : BeanUtils.toBean(response, clazz);
    }

    /**
     * 是否成功获取到数据
     */
    public static boolean success(ResponseVO res) {
        return success(res, "S");
    }

    public static boolean success(ResponseVO res, String successCode) {
        return res != null && StringUtils.isNotBlank(res.getCode()) && successCode.equals(res.getCode());
    }

    public static boolean failed(ResponseVO res) {
        return !success(res, "S");
    }

    public static boolean failed(ResponseVO res, String successCode) {
        return !success(res, successCode);
    }
}
