package com.elitesland.inv.provider;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invlot.param.InvLotCommon21RpcParam;
import com.elitesland.inv.dto.invlot.param.InvLotSaveRpcParam;
import com.elitesland.inv.dto.invlot.resp.InvLotRpcDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author sushiqi
 * @date 2022-04-19
 */

@Validated
@Unicom(domain = InvokeDomain.INVENTORY, path = Application.PATH + InvLotProvider.PATH)
public interface InvLotProvider {
    String PATH = "/invLot";
    /**
     * 批次主信息	新增（共通方法22）
     * <pre>
     *  参数校验：失败，抛出异常
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      success: true，
     *      code 分两种情况：
     *          1.当code 为0 时，说明 全部正常保存成功。
     *          2.当code 为1 时，说明 存在部分数据被锁定。
     *      data: 全部的批次数据
     *      msg: 信息提示
     * </pre>
     *
     * @param source
     * @return ApiResult
     */
    @PostMapping("/createInvLotInfo")
    ApiResult createInvLotInfo(@RequestBody List<InvLotSaveRpcParam> source);

    /**
     * 批次主信息 查询（共通方法21）
     * <pre>
     *  参数校验：无（当无入参时，查询全部）
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      说明：key   为入参的index
     *           value 为查询的全部数据
     *      有入参:
     *      无入参：key 默认为0
     * </pre>
     *
     * @param inVOList
     * @return
     */
    @PostMapping("/getInvLotVOList")
    Map<Integer, List<InvLotRpcDTO>> getInvLotVOList(@RequestBody List<InvLotCommon21RpcParam> inVOList);
}
