package com.elitesland.inv.provider;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.InvStkCommonResultRpcDto;
import com.elitesland.inv.dto.invstk.param.InvStkCommonOperateRpcParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * @author sushiqi
 * @date 2022/04/24
 * <p>
 *     库存操作通用Dubbo接口
 * </p>
 */
@Validated
@Unicom(domain = InvokeDomain.INVENTORY, path = Application.PATH + InvStkCommonProvider.PATH)
public interface InvStkCommonProvider {
    String PATH = "/invStkCommon";
    /**
     * 库存操作公共Dubbo接口
     *
     * @param param
     * @return InvStkCommonResultRpcDto
     * @date 2022/04/24
     * @since 0.2.4-SNAPSHOT
     */
    @PostMapping("/invStkCommonOperate")
    ApiResult<InvStkCommonResultRpcDto> invStkCommonOperate(@RequestBody InvStkCommonOperateRpcParam param);
}
