package com.elitesland.unicom.context;

import cn.hutool.core.util.ReflectUtil;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
@Data
@ApiModel("定制开发版本")
public class Customize {

    /**
     * 通用标准实施
     */
    public final static String CUSTOMIZE_STANDARD = "STANDARD";

    /**
     * 九毛九餐饮
     */
    public final static String CUSTOMIZE_JIUMAOJIU = "JIUMAOJIU";

    /**
     * 威高医疗
     */
    public final static String CUSTOMIZE_WEIGAO = "WEIGAO";

    /**
     * 东明
     */
    public final static String CUSTOMIZE_TONGMING = "TONGMING";

    /**
     * 和府捞面
     */
    public final static String CUSTOMIZE_HEFU = "HEFU";

    /**
     * 国药器械
     */
    public final static String CUSTOMIZE_GUOYAO = "GUOYAO";

    /**
     * 中国燃气
     */
    public final static String CUSTOMIZE_ZG_NRP = "ZG_NRP";

    /**
     * 大昌行
     */
    public final static String CUSTOMIZE_DCH = "DCH";

    /**
     * 立马
     */
    public final static String CUSTOMIZE_LIMA = "LIMA";

    /**
     * 鹏驰五金
     */
    public final static String CUSTOMIZE_EG = "EG";

    /**
     * 吉野家
     */
    public final static String CUSTOMIZE_JYJ = "JYJ";

    /**
     * 雅迪
     */
    public final static String CUSTOMIZE_YADI = "YADI";

    /**
     * Tims 天好咖啡
     */
    public final static String CUSTOMIZE_TIMS = "TIMS";

    /**
     * 所有定制开发的版本标识
     */
    public static List<String> values() {
        Object[] fieldsValue = ReflectUtil.getFieldsValue(Customize.class);
        return Arrays.stream(fieldsValue).map(String::valueOf).collect(Collectors.toList());
    }
}
