/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.unicom.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TenantAdapter
implements UnicomAdapter {
    private static final Logger log = LoggerFactory.getLogger(TenantAdapter.class);
    private static final String ERR_TENANT_CONTEXT_CONFIG = "\u627e\u4e0d\u5230\u79df\u6237\u7684\u5b9e\u65bd\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    public Object filter(List<Object> providers) {
        Object generalProvider;
        HashMap<String, Object> clz = new HashMap<String, Object>();
        for (Object provider : providers) {
            UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
            clz.put(annotation.value(), provider);
        }
        SysTenantDTO tenant = TenantClient.getSessionTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            Object customerProvider = clz.get(tenant.getCustomer());
            if (ObjectUtil.isNotNull(customerProvider)) {
                log.debug("[PHOENIX-UNICOM] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
                return customerProvider;
            }
            Object industryProvider = clz.get(tenant.getIndustry());
            if (ObjectUtil.isNotNull(industryProvider)) {
                log.debug("[PHOENIX-UNICOM] context provider: {}", (Object)industryProvider.getClass().getSimpleName());
                return industryProvider;
            }
        }
        if (ObjectUtil.isNull(generalProvider = clz.get("GENERAL"))) {
            throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
        }
        log.debug("[PHOENIX-UNICOM] context provider: {}", (Object)generalProvider.getClass().getSimpleName());
        return generalProvider;
    }
}

