package com.elitesland.pur;

import com.elitescloud.cloudt.core.logInfo.ApplicationStartedEventListener;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@SpringBootApplication
@EnableTransactionManagement
@EnableCaching
@EnableSwagger2WebMvc
@EnableJpaRepositories("com.elitesland")
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableFeignClients({"com.elitesland.support.provider","com.elitesland.inv.provider","com.elitesland.fin.service"})
public class PurApplication {

    public static void main(String[] args) {
        //设置日志参数获取
        new SpringApplicationBuilder(PurApplication.class)
                .listeners(new ApplicationStartedEventListener())
                .run(args);
    }



}
