package com.elitesland.support;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;


/**
 * @author chrischan11
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableCaching
@Slf4j
@EnableJpaRepositories("com.elitesland")
@EnableAspectJAutoProxy(exposeProxy = true,proxyTargetClass = true)
public class YstSupportApplication {

    public static void main(String[] args) {
        new SpringApplicationBuilder(YstSupportApplication.class)
                .run(args);
    }

}
