package com.elitesland.fin.dto.saleinv;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * 发票明细信息
 * @Package com.elitesland.fin.application.facade.vo.saleinv
 * @date 2022/5/7 11:28
 */
@Data
public class SaleInvDtlRpcDTO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String taxName;

    @ApiModelProperty("税收分类编码")
    private String taxCode;

    @ApiModelProperty("发票行性质")
//    @SysCode(sys = "FIN", mod = "INV_NATURE")
    private String invNature;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("红/蓝票")
    private String invKind;

    @ApiModelProperty("查验状态")
    private String examType;

}
