package com.elitesland.fin.param.payorder;

import com.elitesland.fin.dto.payorder.PayOrderDtlRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:36
 */
@Data
public class PayOrderRpcParam implements Serializable {

    private static final long serialVersionUID = -3556084242260987258L;


    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("应付单类型定义ID")
    private Long apTypeId;

    @ApiModelProperty("应付单类型名称")
    private String apTypeName;

    @ApiModelProperty("应付单类型代码")
    private String apTypeCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("付款单类型代码")
    private String payTypeCode;

    @ApiModelProperty("付款单类型名称")
    private String payTypeName;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("经办人")
    private String operator;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("业务类型")
    private String buType;
    private String buTypeName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际支付金额")
    private BigDecimal realPayAmt;

    @ApiModelProperty("实际支付金额(本位币)")
    private BigDecimal realPayCurAmt;

    @ApiModelProperty("预计付款日期")
    private LocalDateTime apDate;

    @ApiModelProperty("是否预付")
    private Boolean apFlag;

    @ApiModelProperty("创建人名称")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改人名称")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审核拒绝原因")
    private String auditRejection;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("本位币名称")
    private String localCurrCode;

    @ApiModelProperty("本位币编码")
    private String localCurrName;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("剩余未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细集合")
    private List<PayOrderDtlRpcDTO> payOrderDtlRpcDTOList;
}
