package com.elitesland.fin.param.flow;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Data
public class AccountFlowRpcParam implements Serializable {
    private static final long serialVersionUID = 8919070367568525245L;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("发生金额")
    private BigDecimal amount;

    @ApiModelProperty("订单金额")
    private BigDecimal orderAmount;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源平台")
    private String sourcePlatform;


    //add
    @ApiModelProperty("适用单据")
    private String optDoc;

    @ApiModelProperty("适用单据类型")
    private String optDocType;

    @ApiModelProperty("适用单据状态")
    private String optDocStatus;

    @ApiModelProperty("公司编码")
    private String companyCode;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("归属加盟商编码")
    private String secFranchiseeCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("审核人id")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

}
