package com.elitescloud.cloudt.lowcode.dynamic.common;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.cloudt.Application;

import javax.validation.constraints.NotBlank;

/**
 * 流程引擎状态.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/24
 */
public class WorkflowEngineStatusUdc extends BaseUdc<WorkflowEngineStatusUdc> {
    private static final long serialVersionUID = -4846708331475116997L;

    public static final WorkflowEngineStatusUdc RUNNING = new WorkflowEngineStatusUdc("running", "运行中");
    public static final WorkflowEngineStatusUdc CONFIG_EXP = new WorkflowEngineStatusUdc("configExp", "配置异常");
    public static final WorkflowEngineStatusUdc CONNECTION_EXP = new WorkflowEngineStatusUdc("connectionExp", "连接异常");

    public WorkflowEngineStatusUdc() {
    }

    public WorkflowEngineStatusUdc(String value) {
        super(value);
    }

    public WorkflowEngineStatusUdc(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getAppCode() {
        return Application.NAME;
    }

    @Override
    public @NotBlank String getUdcCode() {
        return "workflowEngineStatus";
    }
}
