package com.elitescloud.cloudt.lowcode.dynamic.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-27 11:47
 */
@Data
@NoArgsConstructor  // 自动生成无参构造函数
@AllArgsConstructor // 自动生成包含所有参数的构造函数
public class FieldModel {

    private String dbTableName; //表名
    private String name; // 字段名
    private String type; // 字段类型（如：VARCHAR, INT, DATE等）
    private Integer length; // 字段长度（对于某些类型如VARCHAR是必要的）
    private Integer precision; // 精度，主要用于数值类型，如DECIMAL
    private Integer scale; // 小数位数，与precision搭配使用
    private Boolean nullable; // 字段是否可以为NULL
    private Object defaultValue; // 字段的默认值
    private Boolean primaryKey; // 字段是否是主键
    private Boolean unique; // 字段值是否需要唯一
    private Boolean index; // 是否为该字段创建索引
    private String foreignTable; // 外键关联的表名
    private String foreignField; // 外键关联的字段名
    private String checkConstraint; // 字段检查约束表达式
    private String constraints; // 其他约束（如CHECK约束的表达式）
    private String description; // 字段描述
    private Boolean isVirtual; // 是否为虚拟/计算字段
    private String calculationExpression; // 用于虚拟字段的计算表达式
    private Boolean autoIncrement; // 是否自增
    private String collation; // 字符集和排序规则，主要用于字符串类型


    // 构造函数
    public FieldModel(String name, String type) {
        this.name = name;
        this.type = type;
        // 默认设置，可通过setter方法修改
        this.nullable = true;
        this.primaryKey = false;
        this.unique = false;
        this.index = false;
    }
    public FieldModel(String name, String type, Integer length, Integer precision, Integer scale, Boolean nullable,
                      Object defaultValue, Boolean primaryKey, Boolean unique, Boolean index, String foreignTable,
                      String foreignField, String checkConstraint, String constraints, String description,
                      Boolean isVirtual, String calculationExpression, Boolean autoIncrement, String collation) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.primaryKey = primaryKey;
        this.unique = unique;
        this.index = index;
        this.foreignTable = foreignTable;
        this.foreignField = foreignField;
        this.checkConstraint = checkConstraint;
        this.constraints = constraints;
        this.description = description;
        this.isVirtual = isVirtual;
        this.calculationExpression = calculationExpression;
        this.autoIncrement = autoIncrement;
        this.collation = collation;
    }

}
