package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

/**
 * @author : chen.niu
 * @description : 动态配置表关系表
 * @date : 2024-04-03 16:51
 */
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

@Entity
@Table(name = TableNameConstant.DYNAMIC_CONFIGURATOR_BO_MODEL_RELATION, indexes = {
        @Index(name = "idx_dynamic_cfg2bo_cfg", columnList = "dynamicConfiguratorCode"),
        @Index(name = "idx_dynamic_cfg2bo_bo", columnList = "boModelCode"),
})
@Comment("配置能力与数据模型关系")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class DynamicConfiguratorBoModelRelationDO extends BaseModel {
    private static final long serialVersionUID = 7052575756756553229L;

    @Comment("配置能力编码")
    @Column(nullable = false)
    private String dynamicConfiguratorCode;

    @Comment("BO模型编码")
    @Column(nullable = false)
    private String boModelCode;

    /**
     * 模型类型
     * <p>
     * [udc]cloudt-system:modelRelationType
     * {@link com.elitescloud.cloudt.lowcode.dynamic.common.ModelRelationTypeUdc}
     */
    @Comment("关系类型[udc]cloudt-system:modelRelationType")
    @Column()
    private String boModelType;
}