package com.elitescloud.cloudt.lowcode.dynamic.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 部署模型的记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/25
 */
@Entity
@Table(name = "dynamic_deploy_model_record", indexes = {
        @Index(name = "idx_dynamicdeploym_record", columnList = "recordId"),
        @Index(name = "idx_dynamicdeploym_model", columnList = "boModelCode"),
})
@Comment("部署模型的记录")
@Getter
@Setter
@DynamicInsert
public class DynamicDeployModelRecordDO extends BaseModel {
    private static final long serialVersionUID = -7713021607816899250L;

    @Comment("部署记录ID")
    @Column(nullable = false)
    private Long recordId;

    @Comment("功能模块编码")
    @Column()
    private String configuratorCode;

    @Comment("业务模型编码")
    @Column(nullable = false)
    private String boModelCode;

    @Comment("日志")
    @Column()
    @Lob
    private String logJson;

    @Comment("日志")
    @Column()
    @Lob
    private String prettyLogJson;
}
