package com.elitescloud.cloudt.lowcode.dynamic.service.db;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.TableType;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-23 10:38
 */
public class DbDataMetaUtil extends MetaUtil {
    public static String[] getColumnNamesByCatalog(DataSource ds, String catalog,String schema,String tableName) {
        final List<String> columnNames = new ArrayList<>();
        Connection conn = null;
        try {
            conn = ds.getConnection();

            // catalog和schema获取失败默认使用null代替
//           final String catalog = getCatalog(conn);
//            final String schema = getSchema(conn);
            final DatabaseMetaData metaData = conn.getMetaData();
            try (final ResultSet rs = metaData.getColumns(catalog, schema, tableName, null)) {
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            return columnNames.toArray(new String[0]);
        } catch (Exception e) {
            throw new DbRuntimeException("Get columns error!", e);
        } finally {
            DbUtil.close(conn);
        }
    }

    /**
     * 获得所有表名
     *
     * @param ds        数据源
     * @param schema    表数据库名，对于Oracle为用户名
     * @return 表名列表
     * @since 3.3.1
     */
    public static List<String> getTablesByCatalog(DataSource ds, String catalog,String schema , TableType... types ) {
        final List<String> tables = new ArrayList<>();
        Connection conn = null;
        try {
            conn = ds.getConnection();

            // catalog和schema获取失败默认使用null代替
//            final String catalog = getCatalog(conn);
            if (null == schema) {
                schema = getSchema(conn);
            }

            final DatabaseMetaData metaData = conn.getMetaData();
            try (final ResultSet rs = metaData.getTables(catalog, schema, null, Convert.toStrArray(types))) {
                if (null != rs) {
                    String table;
                    while (rs.next()) {
                        table = rs.getString("TABLE_NAME");
                        if (StrUtil.isNotBlank(table)) {
                            tables.add(table);
                        }
                    }
                }
            }
        } catch (Exception e) {
            throw new DbRuntimeException("Get tables error!", e);
        } finally {
            DbUtil.close(conn);
        }
        return tables;
    }
}
