package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import org.jooq.DataType;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-15 13:32
 */
public interface DatabaseTableOperations {
/**
 * 数据库表操作接口
 */

    /**
     * 创建表的方法
     *
     * @param tableName 表名
     * @param fields 表的字段，使用jooq的Field类型表示
     */
    void createTable(String tableName, org.jooq.Field<?>... fields);

    /**
     * 添加字段的方法
     *
     * @param tableName 表名
     * @param field 要添加的字段，使用jooq的Field类型表示
     */
    void addField(String tableName, org.jooq.Field<?> field);

    /**
     * 修改字段的方法
     *
     * @param tableName 表名
     * @param fieldName 要修改的字段名
     * @param newDataType 修改后的新数据类型
     */
    void modifyField(String tableName, String fieldName, DataType<?> newDataType);

    /**
     * 删除表的方法
     *
     * @param tableName 表名
     */
    void dropTable(String tableName);

    /**
     * 删除字段的方法
     *
     * @param tableName 表名
     * @param field 要删除的字段，使用jooq的Field类型表示
     */
    void dropField(String tableName, org.jooq.Field<?> field);
}
