package com.elitescloud.cloudt.lowcode.dynamic.model.vo.save;

import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 功能模块发布信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Getter
@Setter
@ApiModel(description = "功能模块发布信息")
public class DynamicConfiguratorPublishSaveVO implements Serializable {
    private static final long serialVersionUID = -3360487895061963764L;

    @ApiModelProperty(value = "应用编码", position = 1)
    private String appCode;

    @NotBlank(message = "菜单分组编码为空")
    @ApiModelProperty(value = "菜单分组编码", position = 2, required = true)
    private String menuGroupCode;

    @NotBlank(message = "菜单编码为空")
    @ApiModelProperty(value = "菜单编码", position = 3, required = true)
    private String menuCode;

    @NotBlank(message = "菜单名称为空")
    @ApiModelProperty(value = "菜单名称", position = 3, required = true)
    private String menuName;

    @NotBlank(message = "菜单路由为空")
    @ApiModelProperty(value = "菜单路由", position = 3, required = true)
    private String menuRoute;

    @ApiModelProperty(value = "是否是外部链接", position = 4)
    private Boolean outerLink;

    @ApiModelProperty(value = "外部链接类型", position = 4)
    private PlatformMenusOuterLinkTypeEnum outerLinkTypeEnum;

    @NotNull(message = "功能模块ID为空")
    @ApiModelProperty(value = "功能模块ID", position = 11, required = true)
    private Long id;
}
