package com.elitescloud.cloudt.lowcode.dynamic.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.lowcode.dynamic.model.bo.DynamicModelSimpleBO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.QDynamicBoModelDO;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/22
 */
@Repository
public class DynamicBoModelRepoProc extends BaseRepoProc<DynamicBoModelDO> {
    private static final QDynamicBoModelDO QDO = QDynamicBoModelDO.dynamicBoModelDO;

    public DynamicBoModelRepoProc() {
        super(QDO);
    }

    /**
     * 根据模型编码删除
     *
     * @param boModelCodes
     */
    public void deleteByBoModelCodes(@NotEmpty Collection<String> boModelCodes) {
        super.delete(QDO.boModelCode.in(boModelCodes));
    }

    /**
     * 编码是否存在
     *
     * @param boModelCode
     * @param id
     * @return
     */
    public boolean existsCode(@NotBlank String boModelCode, Long id) {
        return super.exists(QDO.boModelCode, boModelCode, id);
    }

    /**
     * 获取编码
     *
     * @param id
     * @return
     */
    public String getCode(long id) {
        return super.getValue(QDO.boModelCode, id);
    }

    /**
     * 获取是否已创建
     *
     * @param id
     * @return
     */
    public Boolean getCreation(long id) {
        return super.getValue(QDO.creationTable, id);
    }

    /**
     * 根据编码获取
     *
     * @param boModelCode
     * @return
     */
    public DynamicBoModelDO getByCode(@NotBlank String boModelCode) {
        return super.getOneByValue(QDO.boModelCode, boModelCode);
    }

    /**
     * 获取基本信息
     *
     * @param id
     * @return
     */
    public DynamicModelSimpleBO getSimple(long id) {
        return super.get(qBeanSimpleBO(), id);
    }

    /**
     * 根据编码获取基本信息
     *
     * @param boModelCode
     * @return
     */
    public DynamicModelSimpleBO getSimpleByCode(@NotBlank String boModelCode) {
        return super.getOneByValue(qBeanSimpleBO(), QDO.boModelCode, boModelCode);
    }

    private QBean<DynamicModelSimpleBO> qBeanSimpleBO() {
        return Projections.bean(DynamicModelSimpleBO.class, QDO.id, QDO.boModelCode, QDO.boModeName, QDO.businessObjectCode,
                QDO.databaseTableName, QDO.description, QDO.creationTable);
    }
}
