package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicExportParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DynamicFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicImportResult;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-04-02 19:34
 */
public interface DynamicDbApiService {
    ApiResult<Object> insert(String tableName, Map<String, Object> entityData) throws Exception;

    ApiResult<Integer> update(String tableName, Long id, Map<String, Object> entityData);

    ApiResult<Page<?>> queryPage(String tableName, DynamicFieldQueryParam queryParam);

    ApiResult<Map> getById(String tableName, Long id);

    void dynamicExport(String tableName, DynamicExportParam dynamicExportParam, HttpServletResponse response) throws IOException;

    ApiResult<DynamicImportResult> dynamicImport(String tableName, MultipartFile file) throws IOException;

    ApiResult<?> delete(String tableName, Long id);

    ApiResult<?> deleteBatch(String tableName, List<Long> ids);
}
