/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DbTableDo;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.DbTableParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DbTableVo;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbDataSourceMetadataService;
import com.elitescloud.cloudt.lowcode.dynamic.service.db.DbTableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamic/db/model"})
@Api(value="DB\u5143\u6570\u636e\u6a21\u578b", tags={"DB\u5143\u6570\u636e\u6a21\u578b"})
public class DynamicDbModelController {
    private final DSLContext dsl;
    private final DbTableService dbTableService;
    private final DbDataSourceMetadataService dbDataSourceMetadataService;

    public DynamicDbModelController(DSLContext dsl, DbTableService dbTableService, DbDataSourceMetadataService dbDataSourceMetadataService) {
        this.dsl = dsl;
        this.dbTableService = dbTableService;
        this.dbDataSourceMetadataService = dbDataSourceMetadataService;
    }

    @PostMapping(value={"/{tableName}/findByTableName"})
    @ApiOperation(value="\u67e5\u8be2\u5b58\u50a8\u7684\u8868\u540d\u7684\u8868\u5143\u6570\u636e", notes="\u67e5\u8be2\u5b58\u50a8\u7684\u8868\u540d\u7684\u8868\u5143\u6570\u636e")
    public ApiResult<DbTableVo> findByTableName(@PathVariable String tableName) {
        DbTableVo vo = this.dbTableService.findByTableName(tableName);
        return ApiResult.ok((Object)vo);
    }

    @PostMapping(value={"/findAll"})
    @ApiOperation(value="\u67e5\u8be2\u5b58\u50a8\u7684\u8868\u5143\u6570\u636e", notes="\u67e5\u8be2\u5b58\u50a8\u7684\u8868\u5143\u6570\u636e")
    public ApiResult<List<DbTableDo>> findAll() {
        List<DbTableDo> vo = this.dbTableService.findAll();
        return ApiResult.ok(vo);
    }

    @PostMapping(value={"/storeTablesAndFieldsMetadata"})
    @ApiOperation(value="\u91c7\u96c6\u6307\u5b9a\u8868\u548c\u5b57\u6bb5\u5143\u6570\u636e-\u6e05\u7a7a\u6570\u636e\u91c7\u96c6", notes="\u91c7\u96c6\u6307\u5b9a\u8868\u548c\u5b57\u6bb5\u5143\u6570\u636e-\u6e05\u7a7a\u6570\u636e\u91c7\u96c6")
    public ApiResult<String> storeTablesAndFieldsMetadata(@RequestBody DbTableParam dbTableParam) {
        return this.dbTableService.storeTablesAndFieldsMetadata(dbTableParam);
    }
}

