/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoFieldDefinitionDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.entity.DynamicBoModelDO;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoFieldQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelAddViewJsonParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelQueryParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelSaveParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.param.BoModelUpdateParam;
import com.elitescloud.cloudt.lowcode.dynamic.model.vo.DynamicBoModelVo;
import com.elitescloud.cloudt.lowcode.dynamic.repo.BoModelRepository;
import com.elitescloud.cloudt.lowcode.dynamic.repo.ConfiguratorBoModelRelationRepository;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DatabaseTableOperations;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoFieldDefinitionService;
import com.elitescloud.cloudt.lowcode.dynamic.service.dynamic.DynamicBoModelService;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicBoModelServiceImpl
implements DynamicBoModelService {
    private final BoModelRepository repository;
    private final ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository;
    private final DynamicBoFieldDefinitionService boFieldDefinitionService;
    private final DatabaseTableOperations dbDatabaseService;

    public DynamicBoModelServiceImpl(BoModelRepository repository, ConfiguratorBoModelRelationRepository configuratorBoModelRelationRepository, DynamicBoFieldDefinitionService boFieldDefinitionService, DatabaseTableOperations dbDatabaseService) {
        this.repository = repository;
        this.configuratorBoModelRelationRepository = configuratorBoModelRelationRepository;
        this.boFieldDefinitionService = boFieldDefinitionService;
        this.dbDatabaseService = dbDatabaseService;
    }

    @Override
    @Transactional
    public ApiResult<Long> createBoModel(BoModelSaveParam boModelParam) {
        BoModelQueryParam qParam = new BoModelQueryParam();
        qParam.setBoModelCode(boModelParam.getBoModelCode());
        Predicate predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(qParam);
        Optional configurator = this.repository.findOne(predicate);
        if (configurator.isPresent()) {
            return ApiResult.fail((String)("\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d\uff1a" + boModelParam.getBoModelCode()));
        }
        DynamicBoModelDO boModelEntity = new DynamicBoModelDO();
        BeanUtils.copyProperties((Object)boModelParam, (Object)((Object)boModelEntity));
        boModelEntity.setCreationTable(false);
        boModelEntity.setDatabaseTableName("dynamically_" + boModelParam.getBoModelCode());
        this.repository.save((Object)boModelEntity);
        return ApiResult.ok((Object)boModelEntity.getId());
    }

    @Override
    public DynamicBoModelDO getBoModelByCode(String boModelCode) {
        return this.repository.findByBoModelCode(boModelCode).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5BO\u6a21\u578b\u7f16\u7801 :: " + boModelCode));
    }

    @Override
    public DynamicBoModelDO getBoModelById(Long boModelId) {
        return (DynamicBoModelDO)((Object)this.repository.findById(boModelId).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5BO\u6a21\u578b\u7f16\u7801 :: " + boModelId)));
    }

    @Override
    @Transactional
    public ApiResult<Boolean> updateBoModel(String boModelCode, BoModelUpdateParam boModelDetails) {
        DynamicBoModelDO boModel = this.repository.findByBoModelCode(boModelCode).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5BO\u6a21\u578b\u7f16\u7801 :: " + boModelCode));
        BeanUtils.copyProperties((Object)boModelDetails, (Object)((Object)boModel));
        this.repository.save((Object)boModel);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Boolean> updateBoModelById(Long boModelId, BoModelUpdateParam boModelDetails) {
        DynamicBoModelDO boModel = (DynamicBoModelDO)((Object)this.repository.findById(boModelId).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5BO\u6a21\u578b\u7f16\u7801 :: " + boModelId)));
        BeanUtils.copyProperties((Object)boModelDetails, (Object)((Object)boModel));
        this.repository.save((Object)boModel);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional
    public ApiResult<Boolean> deleteBoModel(String boModelCode) {
        this.repository.deleteByBoModelCode(boModelCode);
        this.boFieldDefinitionService.deleteByBoCode(boModelCode);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional
    public ApiResult<Boolean> deleteBoModelById(Long boModelId) {
        DynamicBoModelDO dynamicBoModelDO = this.getBoModelById(boModelId);
        this.deleteBoModel(dynamicBoModelDO.getBoModelCode());
        return ApiResult.ok((Object)true);
    }

    @Override
    public PagingVO<DynamicBoModelDO> searchBoModels(BoModelQueryParam boModelParam) {
        Predicate predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(boModelParam);
        Page page = this.repository.findAll(predicate, (Pageable)boModelParam.getPageRequest());
        return PagingVO.builder().total(page.getTotalElements()).setRecords(page.getContent());
    }

    @Override
    public List<DynamicBoModelDO> searchBoModelList(BoModelQueryParam boModelParam) {
        Predicate predicate = DynamicBoModelService.getPredicateByBoModelQueryParam(boModelParam);
        ArrayList<DynamicBoModelDO> doList = new ArrayList<DynamicBoModelDO>();
        this.repository.findAll(predicate).iterator().forEachRemaining(boModelDo -> doList.add((DynamicBoModelDO)((Object)boModelDo)));
        return doList;
    }

    @Override
    public DynamicBoModelVo getBoModelVoByCode(String boModelCode) {
        DynamicBoModelDO boModelDo = this.getBoModelByCode(boModelCode);
        BoFieldQueryParam boFieldQueryParam = new BoFieldQueryParam();
        boFieldQueryParam.setBasicModuleCode(boModelDo.getBoModelCode());
        boFieldQueryParam.setDbTableName(boModelDo.getDatabaseTableName());
        List<DynamicBoFieldDefinitionDO> boFieldDefinitionList = this.boFieldDefinitionService.searchBoFieldList(boFieldQueryParam);
        DynamicBoModelVo boModelVo = new DynamicBoModelVo();
        BeanUtils.copyProperties((Object)((Object)boModelDo), (Object)((Object)boModelVo));
        boModelVo.setDynamicBoFieldDefinitionDoList(boFieldDefinitionList);
        return boModelVo;
    }

    @Override
    public void updateCreateTable(String boModelCode, boolean b) {
        this.repository.updateCreationTableByBoModelCode(b, boModelCode);
    }

    @Override
    public ApiResult<String> updateBoModelFormJson(BoModelAddViewJsonParam param) {
        this.repository.findById(param.getBoModelId()).ifPresentOrElse(boDo -> {
            boDo.setFormJson(param.getViewJson());
            this.repository.save(boDo);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> updateBoModelListPageJson(BoModelAddViewJsonParam param) {
        this.repository.findById(param.getBoModelId()).ifPresentOrElse(boDo -> {
            boDo.setListPageJson(param.getViewJson());
            this.repository.save(boDo);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok();
    }
}

