/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysNumType;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleAddParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleQParam;
import com.elitescloud.cloudt.platform.model.params.seq.SysPlatformNumberRuleVO;
import com.elitescloud.cloudt.platform.service.ISysPlatformNumberRuleService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/platform/numbering"})
@Api(value="\u53d1\u53f7\u5668-\u89c4\u5219\u7ba1\u7406", tags={"\u53d1\u53f7\u5668-\u89c4\u5219\u7ba1\u7406"})
@BusinessObject(businessType="SysPlatformNumberRule:\u5e73\u53f0\u53d1\u53f7\u89c4\u5219")
public class SysPlatformNumberRuleController {
    private final ISysPlatformNumberRuleService iSysPlatformNumberRuleService;

    public SysPlatformNumberRuleController(ISysPlatformNumberRuleService sysNumberRuleService) {
        this.iSysPlatformNumberRuleService = sysNumberRuleService;
    }

    @PostMapping(value={"/rules"})
    @ApiOperation(value="\u521b\u5efa\u53d1\u53f7\u5668\u89c4\u5219\uff0c\u6210\u529f\u5219\u8fd4\u56de\u5bf9\u5e94ID")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u521b\u5efa\u53d1\u53f7\u5668\u89c4\u5219", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> create(@RequestBody @Valid SysPlatformNumberRuleAddParam rule) {
        return this.iSysPlatformNumberRuleService.create(rule);
    }

    @PutMapping(value={"/rules"})
    @ApiOperation(value="\u66f4\u65b0\u53d1\u53f7\u5668\u89c4\u5219")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u53d1\u53f7\u5668\u89c4\u5219", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> update(@RequestBody @Valid SysPlatformNumberRuleAddParam rule) {
        return this.iSysPlatformNumberRuleService.update(rule);
    }

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u68c0\u7d22\u53d1\u53f7\u5668\u89c4\u5219")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u68c0\u7d22\u53d1\u53f7\u5668\u89c4\u5219")
    public ApiResult<PagingVO<SysPlatformNumberRuleVO>> search(@RequestBody SysPlatformNumberRuleQParam param) {
        return this.iSysPlatformNumberRuleService.search(param);
    }

    @DeleteMapping(value={"/rules/{id}"})
    @ApiOperation(value="\u5220\u9664\u53d1\u53f7\u5668\u89c4\u5219")
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u53d1\u53f7\u5668\u89c4\u5219", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> remove(@PathVariable(value="id") Long id) {
        return this.iSysPlatformNumberRuleService.removeById(id);
    }

    @GetMapping(value={"/rules/{id}"})
    @ApiOperation(value="\u6839\u636e\u89c4\u5219ID\uff0c\u83b7\u53d6\u89c4\u5219\u5bf9\u8c61\uff0c\u5305\u62ec\u89c4\u5219\u660e\u7ec6\u5217\u8868")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u89c4\u5219\u8be6\u7ec6")
    public ApiResult<SysPlatformNumberRuleVO> one(@PathVariable(value="id") Long id) {
        return this.iSysPlatformNumberRuleService.oneCombined(id);
    }

    @ApiOperation(value="\u66f4\u65b0\u542f\u7528\u72b6\u6001", notes="\u81ea\u52a8\u53d6\u53cd\uff0c\u5982\u679c\u5f53\u524d\u662f\u542f\u7528\uff0c\u5219\u4fee\u6539\u4e3a\u7981\u7528\uff0c\u53cd\u4e4b\u4fee\u6539\u4e3a\u542f\u7528")
    @ApiImplicitParam(name="id", value="\u53d1\u53f7\u89c4\u5219ID", required=true)
    @PatchMapping(value={"/update/{id}/enabled"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u542f\u7528\u72b6\u6001", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> updateEnabled(@PathVariable Long id) {
        return this.iSysPlatformNumberRuleService.updateEnabled(id);
    }

    @ApiOperation(value="\u53d6\u53f7\u7c7b\u578b")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/numType"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u53d6\u53f7\u7c7b\u578b")
    public ApiResult<List<CodeNameParam>> numType() {
        List values = Arrays.stream(SysNumType.values()).map(t -> new CodeNameParam(t.name(), t.getDescription())).collect(Collectors.toList());
        return ApiResult.ok(values);
    }
}

