/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcValueParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.platform.model.params.udc.UpdateUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.UpdateUdcValueAllowStartParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u5e73\u53f0udc", tags={"\u5e73\u53f0udc"})
@RequestMapping(value={"/sys/platform/udc"})
@BusinessObject(businessType="SysPlatformUdc:\u5e73\u53f0UDC")
public class SysPlatformUdcController {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformUdcController.class);
    private final SysPlatformUdcService sysPlatformUdcService;

    public SysPlatformUdcController(SysPlatformUdcService sysPlatformUdcService) {
        this.sysPlatformUdcService = sysPlatformUdcService;
    }

    @PostMapping(value={"/addUdc"})
    @ApiOperation(value="\u6dfb\u52a0Udc", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u65b0\u589eUDC", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addUdc(@RequestBody @Valid AddUdcParam addUdcParam) {
        return this.sysPlatformUdcService.addUdc(addUdcParam);
    }

    @PostMapping(value={"/addUdcValue"})
    @ApiOperation(value="\u6dfb\u52a0addUdcValue", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u65b0\u589eUDC\u503c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addUdcValue(@RequestBody @Valid AddUdcValueParam addUdcParam) {
        return this.sysPlatformUdcService.addUdcValue(addUdcParam);
    }

    @ApiOperation(value="UDC\u503c\u7f16\u8f91")
    @PostMapping(value={"/updateUdcValue"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u4fee\u6539UDC\u503c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> updateUdcValue(@RequestBody @Valid UdcValueSaveVO saveVO) {
        return this.sysPlatformUdcService.updateUdcValue(saveVO);
    }

    @ApiOperation(value="\u5220\u9664Udc", notes="\u5e73\u53f0udc")
    @PutMapping(value={"/deleteFlagUdc/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664UDC", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> deleteFlagUdc(@PathVariable Long id) {
        return this.sysPlatformUdcService.deleteUdc(id);
    }

    @ApiOperation(value="\u5220\u9664deleteFlagUdcValue", notes="\u5e73\u53f0udc")
    @PutMapping(value={"/deleteFlagUdcValue/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664UDC\u503c", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> deleteFlagUdcValue(@PathVariable Long id) {
        return this.sysPlatformUdcService.deleteUdcValue(id);
    }

    @PutMapping(value={"/updateUdc/{id}"})
    @ApiOperation(value="\u66f4\u65b0Udc", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u7f16\u8f91UDC", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateUdc(@PathVariable Long id, @RequestBody @Valid UpdateUdcParam updateUdcParam) {
        return this.sysPlatformUdcService.updateUdc(id, updateUdcParam);
    }

    @PutMapping(value={"/updateUdcValueAllowStart"})
    @ApiOperation(value="\u66f4\u65b0UdcValue\u662f\u5426\u542f\u7528", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u65b0\u66f4\u65b0UdcValue\u662f\u5426\u542f\u7528", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateUdcValueAllowStart(@RequestBody @Valid UpdateUdcValueAllowStartParam updateUdcValueAllowStart) {
        return this.sysPlatformUdcService.updateUdcValueAllowStart(updateUdcValueAllowStart.getId(), updateUdcValueAllowStart.getAllowStart());
    }

    @GetMapping(value={"/getUdc/{id}"})
    @ApiOperation(value="id\u67e5\u8be2UDC\u548cvalue", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="id\u67e5\u8be2UDC\u548cvalue")
    public ApiResult<SysPlatformUdcVO> getUdc(@PathVariable Long id) {
        return this.sysPlatformUdcService.getUdc(id);
    }

    @PostMapping(value={"/queryUdc"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2UDC", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2UDC")
    public ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(@RequestBody @Valid QueryUdcParam queryUdcParam) {
        return this.sysPlatformUdcService.queryUdc(queryUdcParam);
    }

    @ApiOperation(value="\u6839\u636eudc\u7f16\u7801\u67e5\u8be2UDC\u503c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801", required=true), @ApiImplicitParam(name="udcCode", value="UDC\u7f16\u7801", required=true)})
    @GetMapping(value={"/valueList"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="udc\u7f16\u7801\u67e5\u8be2")
    public ApiResult<List<CodeNameParam>> udcValues(@NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") @RequestParam(name="appCode") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") String appCode, @NotBlank(message="UDC\u7f16\u7801\u4e3a\u7a7a") @RequestParam(name="udcCode") @NotBlank(message="UDC\u7f16\u7801\u4e3a\u7a7a") String udcCode) {
        return this.sysPlatformUdcService.getValueList(appCode, udcCode);
    }
}

