/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformApiMangeConvert;
import com.elitescloud.cloudt.platform.convert.SysPlatformMenusApiConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.AddButtonParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddFormMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddMenusApiParam;
import com.elitescloud.cloudt.platform.model.params.menus.AddMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.DeleteMenusApiParam;
import com.elitescloud.cloudt.platform.model.params.menus.QueryMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateButtonParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateFormMenusParam;
import com.elitescloud.cloudt.platform.model.params.menus.UpdateMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.MenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAdminMenusRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiManageRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformApiManageRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusApiRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusApiRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepoProc;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.StringPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformMenusServiceImpl
implements SysPlatformMenusService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformMenusServiceImpl.class);
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformMenusRepoProc sysPlatformMenusRepoProc;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformMenusApiRepo sysPlatformMenusApiRepo;
    private final SysPlatformMenusApiRepoProc menusApiRepoProc;
    private final SysPlatformApiManageRepo sysPlatformApiManageRepo;
    private final SysPlatformApiManageRepoProc sysPlatformApiManageRepoProc;
    private final SysPlatformAdminMenusRepoProc adminMenusRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addMenusGroup(AddMenusParam param) {
        SysPlatformMenusDO saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS_GROUP.name());
        return this.saveDo(saveDo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addMenus(AddMenusParam param) {
        SysPlatformMenusDO saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.MENUS.name());
        return this.saveDo(saveDo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addButton(AddButtonParam param) {
        SysPlatformMenusDO saveDo = MenusConvert.INSTANCE.saveParamToDo(param);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.BUTTON.name());
        return this.saveDo(saveDo);
    }

    private ApiResult<Long> saveDo(SysPlatformMenusDO saveDo) {
        List<SysPlatformMenusDO> list = this.sysPlatformMenusRepo.findAllByMenusCode(saveDo.getMenusCode());
        if (!list.isEmpty()) {
            SysPlatformMenusDO obj = list.get(0);
            return ApiResult.fail((String)("\u83dc\u5355\u7f16\u7801\u91cd\u590d\uff1a\uff08\u91cd\u590d\u5e94\u7528\uff1a" + obj.getMenusAppCode() + "-\u83dc\u5355\u540d\u79f0\uff1a" + obj.getMenusName() + "\u7f16\u7801\uff1a" + obj.getMenusCode() + ")"));
        }
        if (StringUtils.hasText((String)saveDo.getMenusParentCode())) {
            SysPlatformMenusDO parentMenu = this.sysPlatformMenusRepoProc.getByMenusCode(saveDo.getMenusParentCode());
            Assert.notNull((Object)((Object)parentMenu), (String)"\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            saveDo.setMenusType(parentMenu.getMenusType());
        }
        return ApiResult.ok((Object)((SysPlatformMenusDO)((Object)this.sysPlatformMenusRepo.save((Object)saveDo))).getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addFormMenus(AddFormMenusParam addMenusParam) {
        SysPlatformMenusDO saveDo = MenusConvert.INSTANCE.saveParamToDo(addMenusParam);
        saveDo.setMenusState(true);
        saveDo.setNodeType(PlatformMenusNodeEnum.FORM_MENUS.name());
        return this.saveDo(saveDo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateFormMenus(Long id, UpdateFormMenusParam updateMenusParam) {
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
            sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
            sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
            sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
            sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
            sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
            sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
            this.sysPlatformMenusRepo.save(sysPlatformAppDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum() {
        return ApiResult.ok(List.of(PlatformMenusOuterLinkTypeEnum.URL.getUdcVO(), PlatformMenusOuterLinkTypeEnum.LCDP.getUdcVO(), PlatformMenusOuterLinkTypeEnum.LCBP.getUdcVO()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateMenusGroup(Long id, UpdateMenusParam updateMenusParam) {
        return this.updateMenus(id, updateMenusParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateMenus(Long id, UpdateMenusParam updateMenusParam) {
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
            sysPlatformAppDO.setMenusType(updateMenusParam.getMenusType());
            sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
            sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
            sysPlatformAppDO.setMenusRoute(updateMenusParam.getMenusRoute());
            sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
            sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
            sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
            sysPlatformAppDO.setOuterLink(updateMenusParam.getOuterLink());
            sysPlatformAppDO.setOuterLinkType(updateMenusParam.getOuterLinkType());
            this.sysPlatformMenusRepo.save(sysPlatformAppDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateButton(Long id, UpdateButtonParam updateMenusParam) {
        AtomicReference<Boolean> allowUpdate = new AtomicReference<Boolean>(false);
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setMenusName(updateMenusParam.getMenusName());
            sysPlatformAppDO.setMenusOrder(updateMenusParam.getMenusOrder());
            sysPlatformAppDO.setMenusParentCode(updateMenusParam.getMenusParentCode());
            sysPlatformAppDO.setMenusDescribe(updateMenusParam.getMenusDescribe());
            sysPlatformAppDO.setMenusIcon(updateMenusParam.getMenusIcon());
            sysPlatformAppDO.setDisplay(updateMenusParam.getDisplay());
            this.sysPlatformMenusRepo.save(sysPlatformAppDO);
            allowUpdate.set(true);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        if (allowUpdate.get().booleanValue()) {
            return ApiResult.ok((Object)true);
        }
        return ApiResult.fail((String)"\u83dc\u5355\u7f16\u7801\u5df2\u7ecf\u5b58\u5728,\u91cd\u590d:");
    }

    private boolean updateVerify(AtomicReference<Boolean> allowUpdate, SysPlatformMenusDO sysPlatformAppDO, String menusCode) {
        List<SysPlatformMenusDO> list;
        if (!sysPlatformAppDO.getMenusCode().equals(menusCode) && !(list = this.sysPlatformMenusRepo.findAllByMenusCode(menusCode)).isEmpty()) {
            allowUpdate.set(false);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagMenus(Long id) {
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO -> {
            sysPlatformMenusDO.setDeleteFlag(1);
            this.sysPlatformMenusRepo.save(sysPlatformMenusDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateMenusState(Long id, Boolean state) {
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(sysPlatformMenusDO -> {
            sysPlatformMenusDO.setMenusState(state);
            this.sysPlatformMenusRepo.save(sysPlatformMenusDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<SysPlatformMenusVO> getMenus(Long id) {
        Optional objDO = this.sysPlatformMenusRepo.findById(id);
        if (objDO.isPresent()) {
            return ApiResult.ok((Object)MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO((SysPlatformMenusDO)((Object)objDO.get())));
        }
        return ApiResult.fail((String)"id\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(QueryMenusParam queryMenusParam) {
        QSysPlatformMenusDO qdo = QSysPlatformMenusDO.sysPlatformMenusDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)qdo.menusAppCode).eq(arg_0), (Object)queryMenusParam.getAppCode()).and(arg_0 -> ((StringPath)qdo.menusName).eq(arg_0), (Object)queryMenusParam.getMenusName()).and(arg_0 -> ((StringPath)qdo.menusCode).eq(arg_0), (Object)queryMenusParam.getMenusCode()).and(arg_0 -> ((StringPath)qdo.menusType).eq(arg_0), (Object)queryMenusParam.getMenusType().name()).and(arg_0 -> ((BooleanPath)qdo.menusState).eq(arg_0), (Object)queryMenusParam.getMenusState()).and(arg_0 -> ((StringPath)qdo.nodeType).eq(arg_0), (Object)queryMenusParam.getNodeType()).getPredicate();
        ArrayList listVO = new ArrayList();
        this.sysPlatformMenusRepo.findAll(predicate).iterator().forEachRemaining(sysPlatformMenusDO -> listVO.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformVO((SysPlatformMenusDO)((Object)sysPlatformMenusDO))));
        return ApiResult.ok(listVO);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
        return ApiResult.ok(List.of(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.getUdcVO(), PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.getUdcVO()));
    }

    @Override
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        getAppMenusVO.setSysPlatformAppVOS(this.sysPlatformAppRepo.findAll().stream().filter(sysPlatformAppDO -> sysPlatformAppDO.getAppState() != false && sysPlatformAppDO.getDeleteFlag() == 0).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList()));
        getAppMenusVO.setSysPlatformMenusVOS(this.sysPlatformMenusRepo.findAll().stream().filter(sysPlatformMenusDO -> sysPlatformMenusDO.getMenusState() != false && sysPlatformMenusDO.getDeleteFlag() == 0).map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO).collect(Collectors.toList()));
        return ApiResult.ok((Object)getAppMenusVO);
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysAppMenusAll(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals((Object)PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals((Object)PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(this.sysPlatformAppRepo.findByAppType(appType).stream().map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList()));
        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(this.sysPlatformMenusRepo.findAllByMenusTypeAndDeleteFlag(menusType, 0).stream().map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO).collect(Collectors.toList()));
        }
        return ApiResult.ok((Object)getAppMenusVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteMenus(Long id) {
        this.sysPlatformMenusRepo.findById(id).ifPresentOrElse(menusDO -> {
            Integer count = this.sysPlatformMenusRepo.findAllByMenusParentCode(menusDO.getMenusCode()).size();
            if (count != 0) {
                throw new BusinessException("\u8bf7\u5148\u5220\u9664\u5b50\u83dc\u5355\u3002\u5b50\u83dc\u5355\u6570\u91cf\uff1a" + count);
            }
            this.sysPlatformMenusRepo.deleteById(id);
            this.adminMenusRepoProc.deleteByMenuCode(menusDO.getMenusCode());
            this.menusApiRepoProc.deleteByMenuCode(menusDO.getMenusCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<GetAppMenusVO> getSysBusAppMenus(PlatformAppMenusTypeEnum platformAppMenusTypeEnum) {
        String appType = null;
        String menusType = null;
        if (platformAppMenusTypeEnum.equals((Object)PlatformAppMenusTypeEnum.MENUS_TYPE_SYS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_SYS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name();
        } else if (platformAppMenusTypeEnum.equals((Object)PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)) {
            appType = PlatformAppTypeEnum.APP_TYPE_BUS.name();
            menusType = PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name();
        }
        GetAppMenusVO getAppMenusVO = new GetAppMenusVO();
        if (appType != null) {
            getAppMenusVO.setSysPlatformAppVOS(this.sysPlatformAppRepo.findByAppTypeAndAppState(appType, true).stream().map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList()));
        }
        if (menusType != null) {
            getAppMenusVO.setSysPlatformMenusVOS(this.sysPlatformMenusRepo.findAllByMenusTypeAndMenusStateAndDeleteFlag(menusType, true, 0).stream().map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO).collect(Collectors.toList()));
        }
        return ApiResult.ok((Object)getAppMenusVO);
    }

    @Override
    public ApiResult<List<SysPlatformMenusApiVO>> getAllAppMenusApi(String appCode) {
        return ApiResult.ok(this.sysPlatformMenusRepoProc.getMenusSumApi(appCode));
    }

    @Override
    public ApiResult<Boolean> addMenusApi(AddMenusApiParam addMenusApiParam) {
        if (addMenusApiParam.getApiId() == null) {
            return ApiResult.fail((String)"\u63a5\u53e3\u6570\u636e\u5f02\u5e38");
        }
        List<SysPlatformMenusApiDO> menusApis = this.sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(addMenusApiParam.getAppId(), addMenusApiParam.getMenusId());
        menusApis.forEach(sysPlatformMenusApiDO -> {
            if (Objects.equals(sysPlatformMenusApiDO.getApiId(), addMenusApiParam.getApiId())) {
                throw new BusinessException("\u63a5\u53e3\u5df2\u6302\u8f7d");
            }
        });
        String apiCode = this.sysPlatformApiManageRepoProc.getCode(addMenusApiParam.getApiId());
        SysPlatformMenusApiDO saveDo = SysPlatformMenusApiConvert.INSTANCE.saveParamToDo(addMenusApiParam);
        saveDo.setApiCode(apiCode);
        this.sysPlatformMenusApiRepo.save((Object)saveDo);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Boolean> deleteMenusApi(DeleteMenusApiParam deleteMenusApiParam) {
        SysPlatformMenusApiDO sysPlatformMenusApiDO = this.sysPlatformMenusApiRepo.findByAppIdAndMenusIdAndApiId(deleteMenusApiParam.getAppId(), deleteMenusApiParam.getMenusId(), deleteMenusApiParam.getApiId());
        Assert.notNull((Object)((Object)sysPlatformMenusApiDO), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.sysPlatformMenusApiRepo.delete((Object)sysPlatformMenusApiDO);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<List<MenusApiVO>> getMenusApis(Long appId, Long menusId) {
        ArrayList<MenusApiVO> voList = new ArrayList<MenusApiVO>();
        List<SysPlatformMenusApiDO> menusApiDo = this.sysPlatformMenusApiRepo.findAllByAppIdAndMenusId(appId, menusId);
        for (SysPlatformMenusApiDO menusApi : menusApiDo) {
            Optional sysPlatformApiManageDO = this.sysPlatformApiManageRepo.findById(menusApi.getApiId());
            if (sysPlatformApiManageDO.isPresent()) {
                MenusApiVO menusApiVO = SysPlatformApiMangeConvert.INSTANCE.doToVo((SysPlatformApiManageDO)((Object)sysPlatformApiManageDO.get()));
                voList.add(menusApiVO);
                continue;
            }
            throw new BusinessException("apiId: " + menusApi.getApiId() + "\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok(voList);
    }

    public SysPlatformMenusServiceImpl(SysPlatformMenusRepo sysPlatformMenusRepo, SysPlatformMenusRepoProc sysPlatformMenusRepoProc, SysPlatformAppRepo sysPlatformAppRepo, SysPlatformMenusApiRepo sysPlatformMenusApiRepo, SysPlatformMenusApiRepoProc menusApiRepoProc, SysPlatformApiManageRepo sysPlatformApiManageRepo, SysPlatformApiManageRepoProc sysPlatformApiManageRepoProc, SysPlatformAdminMenusRepoProc adminMenusRepoProc) {
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
        this.sysPlatformMenusRepoProc = sysPlatformMenusRepoProc;
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.sysPlatformMenusApiRepo = sysPlatformMenusApiRepo;
        this.menusApiRepoProc = menusApiRepoProc;
        this.sysPlatformApiManageRepo = sysPlatformApiManageRepo;
        this.sysPlatformApiManageRepoProc = sysPlatformApiManageRepoProc;
        this.adminMenusRepoProc = adminMenusRepoProc;
    }
}

