/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.SysPlatformSqlExecuteConvert;
import com.elitescloud.cloudt.platform.model.constant.SqlTyeEnum;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformSqlExecuteDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformSqlExecuteDO;
import com.elitescloud.cloudt.platform.model.params.sql.SysPlatformSqlExecuteParam;
import com.elitescloud.cloudt.platform.model.vo.SqlExecuteDataVo;
import com.elitescloud.cloudt.platform.service.SysPlatformSqlExecuteService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformSqlExecuteRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformSqlExecuteRepoProc;
import com.elitescloud.cloudt.system.service.SysAlertService;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SysPlatformSqlExecuteServiceImpl
implements SysPlatformSqlExecuteService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformSqlExecuteServiceImpl.class);
    @Value(value="${sqlexecute.datasource.url:#{null}}")
    private String dbUrl;
    @Value(value="${sqlexecute.datasource.driver-class-name:#{null}}")
    private String dbDriverClassName;
    @Value(value="${sqlexecute.datasource.username:#{null}}")
    private String dbUsername;
    @Value(value="${sqlexecute.datasource.password:#{null}}")
    private String dbPassword;
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private SysPlatformSqlExecuteRepo sqlExecuteRepo;
    @Autowired
    private SysPlatformSqlExecuteRepoProc repoProc;
    @Autowired
    private SysAlertService alertService;
    @Autowired
    private TaskExecutor taskExecutor;

    public void afterPropertiesSet() throws Exception {
        this.jdbcTemplate = this.sqlExecuteDataJdbcTemplate();
    }

    public JdbcTemplate sqlExecuteDataJdbcTemplate() {
        if (this.dbUrl == null) {
            log.info("sql\u6267\u884c\u6570\u636e\u6e90\u914d\u7f6e\u7a7a\uff0c\u4e0d\u6267\u884c");
            return null;
        }
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.dbDriverClassName);
        dataSource.setUrl(this.dbUrl);
        dataSource.setUsername(this.dbUsername);
        dataSource.setPassword(this.dbPassword);
        log.info("sql\u6267\u884c\u6570\u636e\u6e90=" + this.dbDriverClassName);
        log.info("sql\u6267\u884c\u6570\u636e\u6e90=" + this.dbUrl);
        log.info("sql\u6267\u884c\u6570\u636e\u6e90=" + this.dbUsername);
        log.info("sqlExecuteDataJdbcTemplate ok");
        return new JdbcTemplate((DataSource)dataSource);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> importData(List<SqlExecuteDataVo> dataVoList) {
        try {
            for (SqlExecuteDataVo data : dataVoList) {
                this.sqlExecuteRepo.findBySqlCode(data.getSqlCode()).ifPresentOrElse(sdo -> {
                    sdo.setSqlName(data.getSqlName());
                    sdo.setQuerySql(data.getQuerySql());
                    sdo.setCategory(data.getCategory());
                    this.sqlExecuteRepo.save(sdo);
                }, () -> {
                    SysPlatformSqlExecuteDO sysPlatformSqlExecuteDO = new SysPlatformSqlExecuteDO();
                    sysPlatformSqlExecuteDO.setSqlName(data.getSqlName());
                    sysPlatformSqlExecuteDO.setQuerySql(data.getQuerySql());
                    sysPlatformSqlExecuteDO.setCategory(data.getCategory());
                    sysPlatformSqlExecuteDO.setSqlCode(data.getSqlCode());
                    this.sqlExecuteRepo.save(sysPlatformSqlExecuteDO);
                });
            }
            return ApiResult.ok((Object)("\u5bfc\u5165\u6210\u529f:" + dataVoList.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ApiResult.fail((String)("\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public String getSqlByReplaceAll(String sql) {
        String result = sql.replaceAll("[\n\r]", " ");
        result = result.replaceAll("\t", " ");
        result = result.replaceAll("\n", " ");
        result = result.replaceAll("\r", " ");
        result = result.replaceAll("\\r", " ");
        result = result.replaceAll("[\\n\\r]", " ");
        result = result.replaceAll("\\t", " ");
        result = result.replaceAll("\\n", " ");
        result = result.replaceAll(" +", " ");
        result = result.replaceAll(" ", " ");
        result = result.replaceAll("[\u0000-\u001f]", " ");
        result = result.replaceAll("[\\u0000-\\u001f]", " ");
        return result;
    }

    @Override
    public ApiResult<PagingVO<SysPlatformSqlExecuteDO>> page(SysPlatformSqlExecuteParam queryVO) {
        QSysPlatformSqlExecuteDO QDO = QSysPlatformSqlExecuteDO.sysPlatformSqlExecuteDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)QDO.datasourceName).like(arg_0), StringUtils.hasText((String)queryVO.getDatasourceName()) ? "%" + queryVO.getDatasourceName() + "%" : null).and(arg_0 -> ((StringPath)QDO.sqlName).like(arg_0), StringUtils.hasText((String)queryVO.getSqlName()) ? "%" + queryVO.getSqlName() + "%" : null).and(arg_0 -> ((StringPath)QDO.querySql).like(arg_0), StringUtils.hasText((String)queryVO.getQuerySql()) ? "%" + queryVO.getQuerySql() + "%" : null).and(arg_0 -> ((StringPath)QDO.sqlCode).like(arg_0), StringUtils.hasText((String)queryVO.getSqlCode()) ? "%" + queryVO.getSqlCode() + "%" : null).and(arg_0 -> ((StringPath)QDO.category).eq(arg_0), (Object)(StringUtils.hasText((String)queryVO.getCategory()) ? queryVO.getCategory() : null)).getPredicate();
        Page page = this.sqlExecuteRepo.findAll(predicate, (Pageable)queryVO.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<Long> add(SysPlatformSqlExecuteParam addParam) {
        SqlTyeEnum type;
        if (CharSequenceUtil.isNotBlank((CharSequence)addParam.getSqlType()) && (type = SqlTyeEnum.parse(addParam.getSqlType())) == null) {
            return ApiResult.fail((String)"SQL\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        Assert.notBlank((CharSequence)addParam.getSqlCode(), (String)"SQL\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long id = this.repoProc.getIdByCode(addParam.getSqlCode());
        if (id != null) {
            return ApiResult.fail((String)"SQL\u7f16\u7801\u5df2\u5b58\u5728");
        }
        SysPlatformSqlExecuteDO addDo = SysPlatformSqlExecuteConvert.INSTANCE.voToDo(addParam);
        this.sqlExecuteRepo.save(addDo);
        return ApiResult.ok((Object)addDo.getId());
    }

    @Override
    public ApiResult<Boolean> update(Long id, SysPlatformSqlExecuteParam updateParam) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)updateParam.getSqlCode(), (String)"SQL\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.sqlExecuteRepo.findById(id).ifPresentOrElse(manageDO -> {
            if (!CharSequenceUtil.equals((CharSequence)updateParam.getSqlCode(), (CharSequence)manageDO.getSqlCode())) {
                Long existsId = this.repoProc.getIdByCode(updateParam.getSqlCode());
                Assert.isNull((Object)existsId, (String)"SQL\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
            }
            manageDO.setQuerySql(updateParam.getQuerySql());
            manageDO.setSqlName(updateParam.getSqlName());
            manageDO.setDatasourceName(updateParam.getDatasourceName());
            manageDO.setSqlCode(updateParam.getSqlCode());
            manageDO.setCategory(updateParam.getCategory());
            manageDO.setSqlType(updateParam.getSqlType());
            manageDO.setLimitSize(updateParam.getLimitSize());
            this.sqlExecuteRepo.save(manageDO);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<SysPlatformSqlExecuteDO> findById(Long id) {
        Optional sqlDo = this.sqlExecuteRepo.findById(id);
        if (sqlDo.isPresent()) {
            return ApiResult.ok((Object)((SysPlatformSqlExecuteDO)sqlDo.get()));
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Boolean> deleteByIds(List<Long> ids) {
        this.sqlExecuteRepo.deleteAllById(ids);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<SysPlatformSqlExecuteDO> executeQuery(Long id) {
        Optional sysPlatformSqlExecuteDOOptional = this.sqlExecuteRepo.findById(id);
        if (sysPlatformSqlExecuteDOOptional.isPresent()) {
            SysPlatformSqlExecuteDO sDo = (SysPlatformSqlExecuteDO)sysPlatformSqlExecuteDOOptional.get();
            sDo.setExecuteStartTime(LocalDateTime.now());
            String sql = sDo.getQuerySql();
            Exception exp = null;
            int rowNums = 0;
            try {
                String result = this.getSqlByReplaceAll(sql);
                sDo.setQuerySql(result);
                List listMap = this.jdbcTemplate.queryForList(result);
                rowNums = listMap.size();
                sDo.setExecuteSqlResult((String)(listMap.isEmpty() ? "0" : rowNums + "\u6761"));
            }
            catch (Exception e2) {
                exp = e2;
                log.error(e2.getMessage());
                sDo.setExecuteSqlResult(e2.getMessage());
            }
            sDo.setExecuteEndTime(LocalDateTime.now());
            Duration duration = Duration.between(sDo.getExecuteStartTime(), sDo.getExecuteEndTime());
            sDo.setExecuteSqlDelay(duration.toMillis());
            this.sqlExecuteRepo.save(sDo);
            HashMap<String, Object> alertParams = new HashMap<String, Object>(8);
            alertParams.put("success", exp == null ? "\u6b63\u5e38" : "\u5f02\u5e38");
            alertParams.put("failMsg", exp == null ? "/" : exp.getMessage());
            alertParams.put("rowNum", rowNums);
            alertParams.put("result", (rowNums > 0 ? "\u5931\u8d25" : "\u6210\u529f") + "(" + rowNums + "\u884c)");
            alertParams.put("operateType", "\u67e5\u8be2");
            alertParams.put("sql", sDo.getQuerySql());
            alertParams.put("sqlName", sDo.getSqlName());
            alertParams.put("sqlCode", sDo.getSqlCode());
            alertParams.put("category", sDo.getCategory());
            alertParams.put("dsName", sDo.getDatasourceName());
            alertParams.put("startTime", DatetimeUtil.toStr((LocalDateTime)sDo.getExecuteStartTime()));
            alertParams.put("finishTime", DatetimeUtil.toStr((LocalDateTime)sDo.getExecuteEndTime()));
            alertParams.put("costTime", ObjectUtil.defaultIfNull((Object)sDo.getExecuteSqlDelay(), (Object)0));
            CompletableFuture.supplyAsync(() -> this.alertService.sendAlertByTmpl("sqlExecute", null, alertParams), (Executor)this.taskExecutor).whenComplete((v, e) -> {
                if (e == null) {
                    log.info("\u53d1\u9001\u9884\u8b66\u6210\u529f\uff1a{}", (Object)JSONUtil.toJsonString((Object)v));
                    return;
                }
                log.info("\u53d1\u9001\u9884\u8b66\u5931\u8d25\uff1a", e);
            });
            return ApiResult.ok((Object)sDo);
        }
        return ApiResult.fail((String)"id\u4e0d\u5b58\u5728");
    }
}

