/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformSqlExecuteDO;
import com.elitescloud.cloudt.platform.model.params.sql.SysPlatformSqlExecuteParam;
import com.elitescloud.cloudt.platform.model.vo.SqlExecuteDataVo;
import com.elitescloud.cloudt.platform.service.SysPlatformSqlExecuteService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="\u5e73\u53f0\u901a\u7528sql\u6267\u884c", tags={"\u5e73\u53f0\u901a\u7528sql\u6267\u884c"})
@RequestMapping(value={"/sys/platform/sqlexecute"})
public class SysPlatformSqlExecuteController {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformSqlExecuteController.class);
    private final SysPlatformSqlExecuteService sqlExecuteService;

    public SysPlatformSqlExecuteController(SysPlatformSqlExecuteService sqlExecuteService) {
        this.sqlExecuteService = sqlExecuteService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8bb0\u5f55")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<SysPlatformSqlExecuteDO>> page(@RequestBody SysPlatformSqlExecuteParam queryVO) {
        return this.sqlExecuteService.page(queryVO);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0", notes="")
    public ApiResult<Long> add(@RequestBody @Valid SysPlatformSqlExecuteParam addParam) {
        return this.sqlExecuteService.add(addParam);
    }

    @PutMapping(value={"/update/{id}"})
    @ApiOperation(value="\u66f4\u65b0")
    public ApiResult<Boolean> update(@PathVariable Long id, @RequestBody SysPlatformSqlExecuteParam updateParam) {
        return this.sqlExecuteService.update(id, updateParam);
    }

    @GetMapping(value={"/getById/{id}"})
    @ApiOperation(value="id\u67e5\u8be2")
    public ApiResult<SysPlatformSqlExecuteDO> findById(@PathVariable Long id) {
        return this.sqlExecuteService.findById(id);
    }

    @PutMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    public ApiResult<Boolean> deleteByIds(@RequestBody List<Long> ids) {
        return this.sqlExecuteService.deleteByIds(ids);
    }

    @PostMapping(value={"/execute/{id}"})
    public ApiResult<SysPlatformSqlExecuteDO> executeQuery(@PathVariable Long id) {
        return this.sqlExecuteService.executeQuery(id);
    }

    @PostMapping(value={"/import"})
    public ApiResult<String> importData(@RequestParam(value="file") MultipartFile file) {
        try {
            List dataList = ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).headRowNumber(Integer.valueOf(2))).head(SqlExecuteDataVo.class)).sheet(Integer.valueOf(0)).doReadSync();
            for (SqlExecuteDataVo data : dataList) {
                if (data.getSqlCode() != null) continue;
                throw new RuntimeException("\u7f16\u7801\u4e3a\u7a7a\u9519\u8bef\uff1a" + data.getSqlName());
            }
            return this.sqlExecuteService.importData(dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResult.fail((String)("excel\u8bfb\u53d6\u5931\u8d25\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }
}

