/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.service.SysPlatformDatabaseSourceService;
import com.elitescloud.cloudt.system.datasource.DatabaseConfigDTO;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceQueryParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceSaveParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceUpParam;
import com.elitescloud.cloudt.system.datasource.SysPlatformDatabaseSourceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e73\u53f0\u6570\u636e\u5e93\u6e90\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/platform/datasource"})
@Validated
public class SysPlatformDatabaseSourceController {
    @Autowired
    private SysPlatformDatabaseSourceService sysPlatformDatabaseSourceService;

    @ApiOperation(value="\u67e5\u8be2\u5e73\u53f0\u6570\u636e\u5e93\u6e90\u4fe1\u606f")
    @PostMapping(value={"/query"})
    public ApiResult<List<SysPlatformDatabaseSourceVO>> queryDatabaseSources(@ApiParam(value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61", required=true) @Valid @RequestBody SysPlatformDatabaseSourceQueryParam queryParam) {
        return this.sysPlatformDatabaseSourceService.query(queryParam);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u6570\u636e\u5e93\u6e90\u4fe1\u606f")
    @GetMapping(value={"/getById/{id}"})
    public ApiResult<SysPlatformDatabaseSourceVO> getDatabaseSourceById(@ApiParam(value="\u6570\u636e\u5e93\u6e90\u7684ID", required=true) @PathVariable(value="id") Long id) {
        return this.sysPlatformDatabaseSourceService.getById(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u6570\u636e\u5e93\u6e90\u5bc6\u7801")
    @GetMapping(value={"/queryPasswordById/{id}"})
    public ApiResult<String> queryPasswordById(@ApiParam(value="\u6839\u636eID\u83b7\u53d6\u6570\u636e\u5e93\u6e90\u5bc6\u7801", required=true) @PathVariable(value="id") Long id) {
        return this.sysPlatformDatabaseSourceService.queryPasswordById(id);
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5e93\u6e90\u4ee3\u7801\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/getByDbsCode"})
    public ApiResult<SysPlatformDatabaseSourceVO> getDatabaseSourceByDbsCode(@ApiParam(value="\u6570\u636e\u5e93\u6e90\u7684\u4ee3\u7801", required=true) @RequestParam(value="dbsCode") @NotNull String dbsCode) {
        return this.sysPlatformDatabaseSourceService.getByDbsCode(dbsCode);
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b0\u7684\u6570\u636e\u5e93\u6e90\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public ApiResult<Long> saveDatabaseSource(@ApiParam(value="\u5305\u542b\u8981\u4fdd\u5b58\u7684\u6570\u636e\u5e93\u6e90\u4fe1\u606f\u7684\u53c2\u6570\u5bf9\u8c61", required=true) @Valid @RequestBody SysPlatformDatabaseSourceSaveParam saveParam) {
        return this.sysPlatformDatabaseSourceService.save(saveParam);
    }

    @ApiOperation(value="\u66f4\u65b0\u73b0\u6709\u7684\u6570\u636e\u5e93\u6e90\u4fe1\u606f")
    @PutMapping(value={"/update/{id}"})
    public ApiResult<Long> updateDatabaseSource(@ApiParam(value="\u8981\u66f4\u65b0\u7684\u6570\u636e\u5e93\u6e90ID", required=true) @PathVariable(value="id") @NotNull Long id, @ApiParam(value="\u5305\u542b\u66f4\u65b0\u5185\u5bb9\u7684\u53c2\u6570\u5bf9\u8c61", required=true) @Valid @RequestBody SysPlatformDatabaseSourceUpParam upParam) {
        return this.sysPlatformDatabaseSourceService.update(id, upParam);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u6570\u636e\u5e93\u6e90\u4fe1\u606f")
    @DeleteMapping(value={"/delete/{id}"})
    public ApiResult<Long> deleteDatabaseSource(@ApiParam(value="\u8981\u5220\u9664\u7684\u6570\u636e\u5e93\u6e90ID", required=true) @PathVariable(value="id") @NotNull Long id) {
        return this.sysPlatformDatabaseSourceService.delete(id);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u7684\u53ef\u7528\u6027")
    @PostMapping(value={"/testConnection"})
    public ApiResult<String> testDatabaseConnection(@ApiParam(value="\u5305\u542b\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u4fe1\u606f\u7684\u5bf9\u8c61", required=true) @Valid @RequestBody DatabaseConfigDTO config) {
        return this.sysPlatformDatabaseSourceService.testConnection(config);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u914d\u7f6e\u7684\u53ef\u7528\u6027")
    @PostMapping(value={"/testConnectionById/{dsId}"})
    public ApiResult<String> testDatabaseConnection(@PathVariable(value="dsId") @NotNull Long dsId) {
        return this.sysPlatformDatabaseSourceService.testConnectionById(dsId);
    }
}

