/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.SysPlatformCurrencyConvert;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformCurrencyDO;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyPageRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.CurrencySaveVO;
import com.elitescloud.cloudt.platform.service.SysPlatformCurrencyService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformCurrencyRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformCurrencyRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysPlatformCurrencyServiceImpl
implements SysPlatformCurrencyService {
    private static final SysPlatformCurrencyConvert CONVERT = SysPlatformCurrencyConvert.INSTANCE;
    @Autowired
    private SysPlatformCurrencyRepo currencyRepo;
    @Autowired
    private SysPlatformCurrencyRepoProc currencyRepoProc;

    @Override
    public ApiResult<PagingVO<CurrencyPageRespVO>> page(CurrencyPageQueryVO queryVO) {
        PagingVO result = this.currencyRepoProc.pageMng(queryVO).map(CONVERT::do2PageRespVO);
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(CurrencySaveVO saveVO) {
        SysPlatformCurrencyDO currencyDO = null;
        try {
            currencyDO = saveVO.getId() == null ? this.convertForInsert(saveVO) : this.convertForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.currencyRepo.save((Object)currencyDO);
        return ApiResult.ok((Object)currencyDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.currencyRepoProc.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> switchEnabled(long id) {
        Boolean enabled = this.currencyRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.currencyRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<CurrencyDetailRespVO> get(Long id) {
        return this.currencyRepoProc.getOptional(id).map(CONVERT::do2DetailRespVO).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    private SysPlatformCurrencyDO convertForInsert(CurrencySaveVO saveVO) {
        SysPlatformCurrencyDO currencyDO = CONVERT.saveVo2Do(saveVO);
        Assert.hasText((String)saveVO.getCurrCode(), (String)"\u8d27\u5e01\u7f16\u7801\u4e3a\u7a7a");
        boolean exists = this.currencyRepoProc.existsCode(saveVO.getCurrCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u8d27\u5e01\u7f16\u7801\u5df2\u5b58\u5728");
        if (currencyDO.getDispDecimal() == null) {
            currencyDO.setDispDecimal(0);
        }
        Assert.isTrue((currencyDO.getDispDecimal() >= 0 ? 1 : 0) != 0, (String)"\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        if (currencyDO.getEnabled() == null) {
            currencyDO.setEnabled(false);
        }
        return currencyDO;
    }

    private SysPlatformCurrencyDO convertForUpdate(CurrencySaveVO saveVO) {
        SysPlatformCurrencyDO currencyDO = (SysPlatformCurrencyDO)((Object)this.currencyRepoProc.get(saveVO.getId()));
        Assert.hasText((String)saveVO.getCurrCode(), (String)"\u8d27\u5e01\u7f16\u7801\u4e3a\u7a7a");
        Assert.isTrue((boolean)currencyDO.getCurrCode().equals(saveVO.getCurrCode()), (String)"\u8d27\u5e01\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
        CONVERT.copySaveVo2Do(saveVO, currencyDO);
        if (currencyDO.getDispDecimal() == null) {
            currencyDO.setDispDecimal(0);
        }
        Assert.isTrue((currencyDO.getDispDecimal() >= 0 ? 1 : 0) != 0, (String)"\u5c0f\u6570\u4f4d\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        if (currencyDO.getEnabled() == null) {
            currencyDO.setEnabled(false);
        }
        return currencyDO;
    }
}

